<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">My Profile</h1>
    <?php if(\Auth::user()->role == 1): ?>
    <a href="<?php echo e(asset('usermanage')); ?>" class="pull-right">Back To List</a>
    <?php endif; ?>
</div>
<div class="row mb-3">
    <div class="col-lg-4">
        <div class="card mb-3">
            <div class="card-body text-center shadow">
                <form action="<?php echo e(asset('usermanage/changeprofileimage/'.$user->id)); ?>" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />
                    <?php if($user->profile_image): ?>
                    <img class="rounded-circle img-thumbnail mb-3 mt-4" src="<?php echo e(asset('profile_image/'.$user->profile_image)); ?>" style="height:170px;">
                    <?php else: ?>
                    <img class="rounded-circle img-thumbnail mb-3 mt-4" src="<?php echo e(asset('images/blank_user.png')); ?>" style="height:170px;">
                    <?php endif; ?>
                    <div class="mb-3">
                        <input type="file" name="profile_image" id="profile_image" style="opacity:0;width:0" />
                        <button id="btn-upload" class="btn btn-primary btn-sm" type="button">Change Photo</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="row">
            <div class="col">
                <div class="card shadow mb-3">
                    <div class="card-header py-3">
                        <p class="text-primary m-0 fw-bold">User Settings</p>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(asset('usermanage/updateuser/'.$user->id)); ?>" class="user" id="registerform">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="username"><strong>Username</strong></label>
                                            <input class="form-control" type="text" disabled id="username" placeholder="" value="<?php echo e($user->username); ?>">
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="first_name"><strong>Full Name</strong></label>
                                            <input class="form-control" type="text" value="<?php echo e($user->name); ?>" name="name" required />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="email"><strong>Email Address</strong></label>
                                            <input class="form-control" type="email" id="email" value="<?php echo e($user->email); ?>" name="email">
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="email"><strong>Mobile Number</strong></label>
                                            <input class="form-control" type="number" id="email" value="<?php echo e($user->mobile); ?>" name="mobile" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label"><strong>PAN No.</strong></label>
                                            <input class="form-control" type="text"  value="<?php echo e($user->pan_no); ?>" name="pan_no">
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label"><strong>Blood Group</strong></label>
                                            <input class="form-control" type="text"  value="<?php echo e($user->boold_group); ?>" name="boold_group">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <button class="btn btn-primary btn-sm" type="submit">Save Settings</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card shadow d-none">
                    <div class="card-header py-3">
                        <p class="text-primary m-0 fw-bold">Account Details</p>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(asset('usermanage/updatetoken/'.$user->id)); ?>" class="user" id="WalletAddressform">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label class="form-label" for="address"><strong>Wallet Address</strong></label>
                                <input class="form-control" type="text" id="address" value="<?php echo e($user->token); ?>" placeholder="Wallet Address" name="token" required>
                            </div>
                            <div class="mb-3"><button class="btn btn-primary btn-sm" type="submit">Save&nbsp;Settings</button></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card shadow mb-3">
            <div class="card-header py-3">
                <p class="text-primary m-0 fw-bold">Address Information</p> 
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(asset('usermanage/updateuseraddress/'.$user->id)); ?>" class="user" id="registerform">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <div class="row">
                            <div class="col">
                                <div class="mb-3">
                                    <label class="form-label">Enter Country</label>
                                    <input class="form-control" type="text"  name="country"  value="<?php echo e($user->country); ?>" placeholder="Country">
                                </div>
                            </div>
                            <div class="col">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Enter State</strong></label>
                                    <input class="form-control" type="text"  name="state"  placeholder="" value="<?php echo e($user->state); ?>">
                                </div>
                            </div>
                            <div class="col">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Enter District</strong></label>
                                    <input class="form-control" type="text"  name="district"  placeholder="" value="<?php echo e($user->district); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Enter City/Village</strong></label>
                                    <input class="form-control" type="text"  name="city"  placeholder="" value="<?php echo e($user->city); ?>">
                                </div>
                            </div>
                            <div class="col">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Enter Post Code</strong></label>
                                    <input class="form-control" type="text"  name="pin_code"  placeholder="" value="<?php echo e($user->pin_code); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col">
                                <div class="mb-3">
                                    <label class="form-label"><strong>Enter More..</strong></label>
                                    <input class="form-control" type="text"  name="address"  placeholder="" value="<?php echo e($user->address); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <button class="btn btn-primary btn-sm" type="submit">Save Settings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card shadow mb-3">
            <div class="card-header py-3">
                <p class="text-primary m-0 fw-bold">Bank Account Information
                    <button class="btn btn-info btn-sm float-right" id="openaddmodel">
                        Add More Bank <i class="fas fa-plus"></i>
                    </button>
                </p> 

            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="Datatable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Payment Type</th>
                                <th>Payee Name / Platform Name</th>
                                <th>Account Number / Wallet Address</th>
                                <th>Bank Name</th>
                                <th>Branch Name</th>
                                <th>IFSC Code</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="openaddmodelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Bank Account Detials with Wallet Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(asset('usermanage/savebankdetails/'.$user->id)); ?>" id="quickForm" method="post">
                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />
                <input type="hidden" name="update_id" value="" />
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label>Select Payment Option</label>
                            <select class="form-control" name="payment_type" id="slectpaymentoption">
                                <option value="Bank Details">Bank Details</option>
                                <option value="Crypto Wallet Address">Crypto Wallet Address</option>
                            </select>
                        </div>
                    </div>
                    <div class="row" id="bankdetails">
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="Payee Name" name="payee_name" required />
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-user" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="Account Number " name="account_number" required/>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-id-card" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <select class="form-control" name="bank_name" id="bank" required>
                                <option> Select Bank </option>
                                <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($bank->name); ?>" ><?php echo e($bank->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-university" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="Branch" name="branch" required />
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-map-marker" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="IFSC Code"  name="ifsc" required/>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="crypto" style="display:none;">
                        <div class="input-group mb-3 col-sm-6">
                            <select class="form-control" name="platform_name" required>
                                <option> Select Platform Name </option>
                                <option value="BEP20 Wallet Address" >BEP20 Wallet Address</option>
                                <option value="TRC20 Wallet Address" >TRC20 Wallet Address</option>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-university" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="Enter Wallet Address" name="wallet_address" required />
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-user" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save Data</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function () {
        $(function () {
            $('#btn-upload').click(function (e) {
                e.preventDefault();
                $('#profile_image').click();
            });
        });
        $(document).on('change', '#profile_image', function () {
            $(this).closest('form').submit();
        });
        $(document).on('change', '#slectpaymentoption', function () {
            if ($(this).val() == 'Bank Details')
            {
                $(document).find("#crypto").hide();
                $(document).find("#crypto input").val('');
                $(document).find("#crypto select").val('');
                $(document).find("#bankdetails").show();
            } else
            {
                $(document).find("#crypto").show();
                $(document).find("#bankdetails").hide();
                $(document).find("#bankdetails input").val('');
                $(document).find("#bankdetails select").val('');
            }
        });

        $(function () {
            $('#registerform').validate({
                rules: {
                    username: {
                        required: true,
                        alphanumeric: true
                    }
                },
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
        $(function () {
            $('#WalletAddressform').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });


        var tabledata = $('#Datatable').DataTable({
            processing: true,
            serverSide: true,
            ajax: '<?php echo e(asset("usermanage/bankdata/".$user->id)); ?>',
            columns: [
                {data: 'payment_type', name: 'payment_type'},
                {data: 'holder_name', name: 'holder_name'},
                {data: 'number', name: 'number'},
                {data: 'bank_name', name: 'bank_name'},
                {data: 'branch_name', name: 'branch_name'},
                {data: 'ifsc_code', name: 'ifsc_code'},
                {data: 'action', name: 'action', orderable: false, searchable: false, width: '100px'}
            ]
        });

        $(document).on('click', '#openaddmodel', function () {
            $('#openaddmodelModal').modal('show');
        });
        $(document).on('click', '.delete_btn', function () {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#17a2b8',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?php echo e(asset("usermanage/savebankdetails/".$user->id)); ?>',
                        data: {delete_row: 'delete_row', 'row_id': $(this).attr('id')},
                        type: "POST",
                        headers: {
                            'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                        },
                        success: function (data)
                        {
                            tabledata.draw();
                        },
                        cache: false,
                    });
                }
            });
        });
        $(document).on('click', '.update_btn', function () {
            $.ajax({
                url: '<?php echo e(asset("usermanage/savebankdetails/".$user->id)); ?>',
                data: {edit_data: 'edit_data', 'row_id': $(this).attr('id')},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    if (data.row.payment_type == 'Bank Details')
                    {
                        $(document).find("#crypto").hide();
                        $(document).find("#crypto input").val('');
                        $(document).find("#crypto select").val('');
                        $(document).find("#bankdetails").show();
                    } else
                    {
                        $(document).find("#crypto").show();
                        $(document).find("#bankdetails").hide();
                        $(document).find("#bankdetails input").val('');
                        $(document).find("#bankdetails select").val('');
                    }
                    $(document).find("input[name='update_id']").val(data.row.id);
                    $(document).find("input[name='payee_name']").val(data.row.holder_name);
                    $(document).find("input[name='account_number']").val(data.row.number);
                    $(document).find("select[name='bank_name']").val(data.row.bank_name);
                    $(document).find("input[name='branch']").val(data.row.branch_name);
                    $(document).find("input[name='ifsc']").val(data.row.ifsc_code);
                    $(document).find("select[name='payment_type']").val(data.row.payment_type);
                    $(document).find("select[name='platform_name']").val(data.row.platform_name);
                    $(document).find("input[name='wallet_address']").val(data.row.wallet_address);
                    $('#openaddmodelModal').modal('show');
                },
                cache: false,
            });
        });
        $(function () {
            $('#quickForm').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    element.closest('.form-group').append(error);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/profile.blade.php ENDPATH**/ ?>