<?php $__env->startSection('content'); ?>
<style>
    .image{
        height: 80px;
    }

</style>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Package Management </h1>
</div>
<div class="">
    <button class="btn btn-success" id="openaddmodel">
        Add New Package <i class="fas fa-plus"></i>
    </button>
    <a class="btn btn-info" href="<?php echo e(asset('packages/referralplan')); ?>">
        Referral Plan <i class="fas fa-plus"></i>
    </a>
    <br>
    <br>
    <div class="row">
        <div class="col-md-12">
            <div class="" >
                <table id="Datatable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Code</th>
                            <th>Amount (in USDT)</th>
                            <th>Amount (in INR)</th>
                            <th>Security</th>
                            <th>ROI %</th>
                            <th>No of Workdays</th>
                            <th>Calculation</th>
                            <th>Payout Frequency</th>
                            <th>Referral Plan</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="openaddmodelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Package</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(asset('packages/saveproduct')); ?>" id="quickForm" method="post" enctype="multipart/form-data">
                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />
                <input type="hidden" name="update_id" value="" />
                <div class="modal-body">
                    <!-- Package Name -->
                    <div class="mb-3">
                        <label>Package Name</label>
                        <input type="text" class="form-control" name="package_name" required placeholder="Enter package name">
                    </div>

                    <!-- Package Code -->
                    <div class="mb-3">
                        <label>Package Code</label>
                        <input type="text" class="form-control" name="code" required placeholder="Enter package code">
                    </div>

                    <!-- Amounts side by side -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Amount (in USDT)</label>
                            <input type="number" step="0.01"  name="usdt" required class="form-control" placeholder="Enter amount in USDT">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Amount (in INR)</label>
                            <input type="number" step="0.01" name="mrp" class="form-control" placeholder="Enter amount in INR">
                        </div>
                    </div>

                    <!-- Security -->
                    <div class="mb-3">
                        <label>Security</label>
                        <select class="form-control" name="security">
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>

                    <!-- ROI and Workdays side by side -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>ROI to Investor (%)</label>
                            <input type="number" name="roi_per" step="0.01" class="form-control" placeholder="Enter ROI %">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>No of Workdays</label>
                            <input type="number" name="number_of_day" class="form-control" placeholder="Enter workdays">
                        </div>
                    </div>

                    <!-- Calculation + Payout side by side -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Calculation Type</label>
                            <select class="form-control" name="calculation">
                                <option value="Daily">Daily</option>
                                <option value="Weekly">Weekly</option>
                                <option value="Fortnightly">Fortnightly</option>
                                <option value="Monthly">Monthly</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Payout Frequency</label>
                            <select class="form-control" name="payout">
                                <option value="Daily">Daily</option>
                                <option value="Weekly">Weekly</option>
                                <option value="Fortnightly">Fortnightly</option>
                                <option value="Monthly">Monthly</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label>Referral Plan</label>
                        <select class="form-control" name="plan" required>
                            <option value="">Select One</option>
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->code); ?> / <?php echo e($plan->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save Data</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    var tabledata = $('#Datatable').DataTable({
        processing: true,
        serverSide: true,
        "order": [[1, "asc"]],
        ajax: '<?php echo e(asset("packages/data")); ?>',
        columns: [
            {data: 'package_name', name: 'package_name'},
            {data: 'code', name: 'code'},
            {data: 'usdt', name: 'usdt'},
            {data: 'mrp', name: 'mrp'},
            {data: 'security', name: 'security'},
            {data: 'roi_per', name: 'roi_per'},
            {data: 'number_of_day', name: 'number_of_day'},
            {data: 'calculation', name: 'calculation'},
            {data: 'payout', name: 'payout'},
            {data: 'plan', name: 'plan'},
            {data: 'action', name: 'action', orderable: false, searchable: false, width: '100px'}
        ]
    });

    $(document).on('click', '#openaddmodel', function () {
        $('#openaddmodelModal').modal('show');
    });
    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo e(URL::asset('packages/delete')); ?>",
                    data: {delete_row: 'delete_row', 'row_id': $(this).attr('id')},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        tabledata.draw();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.update_btn', function () {
        $.ajax({
            url: "<?php echo e(URL::asset('packages/editdata')); ?>",
            data: {edit_data: 'edit_data', 'row_id': $(this).attr('id')},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                $(document).find("input[name='update_id']").val(data.row.id);
                $(document).find("input[name='package_name']").val(data.row.package_name);
                $(document).find("input[name='code']").val(data.row.code);
                $(document).find("input[name='usdt']").val(data.row.usdt);
                $(document).find("input[name='mrp']").val(data.row.mrp);
                $(document).find("input[name='roi_per']").val(data.row.roi_per);
                $(document).find("input[name='number_of_day']").val(data.row.number_of_day);
                $(document).find("select[name='calculation']").val(data.row.calculation);
                $(document).find("select[name='payout']").val(data.row.payout);
                $(document).find("select[name='plan']").val(data.row.plan);
                $(document).find("select[name='security']").val(data.row.security);
                $(document).find("textarea[name='extra_info']").val(data.row.extra_info);
                $('#openaddmodelModal').modal('show');
            },
            cache: false,
        });
    });

    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/packages.blade.php ENDPATH**/ ?>