<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>MalaysianTrade | Login / Register</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <style>
            body {
                background-color: #fff;
                color: #000;
                font-family: Arial, sans-serif;
            }

            .auth-container {
                max-width: 420px;
                margin: 5vh auto;
                background-color: #fff;
                color:#000;
                padding: 25px 20px;
                border-radius: 12px;
                box-shadow: 0 0 20px #000;
            }

            .auth-logo {
                display: block;
                max-width: 180px;
                margin: 0 auto 25px auto;
            }

            .nav-tabs {
                border-bottom: 1px solid #2b2f38;
            }

            .nav-tabs .nav-link {
                color: #000;
            }

            .nav-tabs .nav-link.active {
                color: #000;
                background-color: transparent;
                border-color: transparent transparent #fcd535;
            }


            ::placeholder {
                color: #aaa !important;
                opacity: 1;
            }

            .btn-yellow {
                background-color: #fcd535;
                color: #000;
                font-weight: bold;
            }

            .btn-yellow:hover {
                background-color: #e5c124;
            }

            .divider {
                text-align: center;
                margin: 20px 0;
                color: #888;
                font-size: 14px;
            }

            .social-btn {
                background-color: transparent;
                border: 1px solid #2b2f38;
                color: #000;
                width: 100%;
            }

            .social-btn:hover {
                background-color: #2b2f38;
            }

            .social-btn img {
                margin-right: 8px;
            }
        </style>
    </head>
    <body>

        <div class="container">
            <div class="auth-container">
                <img src="<?php echo e(asset('images/logo.png')); ?>" alt="MalaysianTrade Logo" class="auth-logo img-fluid">

                <ul class="nav nav-tabs justify-content-center mb-4" id="authTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="login-tab" data-bs-toggle="tab" data-bs-target="#login" type="button" role="tab">Login</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="register-tab" data-bs-toggle="tab" data-bs-target="#register" type="button" role="tab">Register</button>
                    </li>
                </ul>
                <div class="tab-content" id="authTabsContent">

                    <!-- Login Tab -->
                    <div class="tab-pane fade show active" id="login" role="tabpanel">
                        <?php if(\Session::get('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            <?php echo e(\Session::get('success')); ?>

                        </div>
                        <?php endif; ?>
                        <?php if(\Session::get('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-exclamation-triangle"></i> Error!</h5>
                            <?php echo e(\Session::get('error')); ?>

                        </div>
                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('login')); ?>" class="user" id="loginform">
                            <?php echo e(csrf_field()); ?>

                            <input type="text" style="display:none">
                            <input type="password" style="display:none">
                            <div class="mb-3">
                                <label>User ID</label>
                                <input  type="text" placeholder="Enter UserID" class="form-control form-control-user <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="username" value="<?php echo e(old('username')); ?>" required  autofocus>
                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <input id="password" class="block mt-1 w-full password form-control form-control-user <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="password" placeholder="Password" name="password" required />
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <button type="submit" class="btn btn-yellow w-100">Log In</button>
                        </form>

                        <div class="divider">or</div>

                        <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/color/20/google-logo.png"/> Continue with Google
                        </button>
                        <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/ios-filled/20/mac-os.png"/> Continue with Apple
                        </button>
                        <button class="btn social-btn">
                            <img src="https://img.icons8.com/ios-filled/20/telegram-app.png"/> Continue with Telegram
                        </button>
                    </div>

                    <!-- Register Tab -->
                    <div class="tab-pane fade" id="register" role="tabpanel">
                        <form method="POST" action="<?php echo e(route('register')); ?>" class="user" id="registerform">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label>Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Enter your full name" required>
                            </div>

                            <div class="mb-3">
                                <label>Mobile Number</label>
                                <div class="input-group">
                                    <select class="form-select" name="country_code" style="max-width: 100px;">
                                        <option value="+1">+1</option>
                                        <option value="+44">+44</option>
                                        <option value="+91" selected>+91</option>
                                        <option value="+61">+61</option>
                                        <option value="+971">+971</option>
                                    </select>
                                    <input type="text" name="mobile" class="form-control" placeholder="Enter phone number" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label>PAN Card</label>
                                <input type="text" name="pan_no" class="form-control" placeholder="ABC123FG">
                            </div>
                            <div class="mb-3">
                                <label>Email ID</label>
                                <input type="email" name="email" class="form-control" placeholder="email@example.com">
                            </div>

                            <div class="mb-3">
                                <label>Country</label>
                                <input type="text" class="form-control" name="country" required placeholder="Enter your country">
                            </div>

                            <div class="mb-3">
                                <label>State</label>
                                <input type="text" class="form-control" name="state" placeholder="Enter your state">
                            </div>

                            <div class="mb-3">
                                <label>Referred By</label>
                                <?php if(request('sponser')): ?>
                                <input id="sponsor_change" class="form-control form-control-user" type="text" value="<?php echo e(request('sponser')); ?>" readonly placeholder="Sponser ID" name="sponser" required />
                                <input class="form-control form-control-user" type="hidden" value="<?php echo e(request('position')); ?>"  placeholder="Referral" name="position" required />
                                <?php else: ?>
                                <input id="sponsor_change" class="form-control form-control-user" type="text" value="<?php echo e(request('reffer')); ?>"  placeholder="Referral" name="sponser" required />
                                <?php endif; ?>
                                <div id="sponsor_response"></div>
                            </div>

                            <button type="submit" class="btn btn-yellow w-100">Register</button>
                        </form>

                        <div class="divider">or</div>

                        <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/color/20/google-logo.png"/> Continue with Google
                        </button>
                        <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/ios-filled/20/mac-os.png"/> Continue with Apple
                        </button>
                        <button class="btn social-btn">
                            <img src="https://img.icons8.com/ios-filled/20/telegram-app.png"/> Continue with Telegram
                        </button>
                    </div>

                </div>
            </div>
        </div>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
        <!-- Core plugin JavaScript-->
        <script src="<?php echo e(asset('plugins/jquery-easing/jquery.easing.min.js')); ?>"></script>
        <!-- Custom scripts for all pages-->
        <script src="<?php echo e(asset('js/sb-admin-2.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/jquery.validate.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/additional-methods.min.js')); ?>"></script>
        <script>
$(document).ready(function () {


    $(document).on('blur', '#sponsor_change', function () {
        if ($(this).val() != '')
        {
            var sponsor = $("#sponsor_change").val().trim();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                url: "<?php echo e(asset('frontdata/fetchsponsor')); ?>",
                method: "POST",
                data: {sponsor: sponsor, _token: _token},
                success: function (response)
                {
                    if (response) {
                        $("#sponsor_response").html(response);
                    } else {
                        $("#sponsor_response").html('Invalid Sponsor ID');
                    }
                }
            })
        }
    });
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $(function () {
        $('#registerform').validate({
            rules: {
                username: {
                    required: true,
                    alphanumeric: true
                },
                mobile: {
                    minlength: 10,
                    maxlength: 10

                },
                password: {
                    minlength: 6
                },
                password_confirm: {
                    minlength: 6,
                    equalTo: "#samepassword"
                }
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                error.insertAfter(element);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


});
        </script>
    </body>
</html>
<?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/auth/login.blade.php ENDPATH**/ ?>