

<?php $__env->startSection('content'); ?>
<style>
    .th{
        background: #e2e3f1;
    }
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
</style>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-white-800">Send Admin Withdrawal Request</h1>
</div>
<table class="table table-striped">
    <tr>
        <td>Withdrawal Amount</td>
        <td><?php echo e(App\WalletRequest::amountFormat($cash_amount)); ?></td>
    </tr>
    <tr>
        <td colspan="2" class="text-center">
            <?php if($user->withdrawal_btn == 0 && $cash_amount >= 500): ?>
            <button data-toggle="collapse" data-target="#demo" class="btn btn-block btn-warning">Send Withdrawal Request</button>
            <div id="demo" class="collapse" style="width:400px;margin:auto;">
                <br>
                <form class="user" id="WalletAddressform" action="<?php echo e(asset('wallet/cashrequest')); ?>" method="post">
                    <?php echo e(csrf_field()); ?>

                    <div class="mb-3">
                        <label class="form-label"><strong>Enter Amount</strong></label>
                        <input class="form-control form-control-user" id="amount_count" type="number" placeholder="Enter Amount" name="amount" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><strong>Select Bank You Want to Receive Amount</strong></label>
                        <select name="bank_id" class="form-control" required>
                            <option value="">Select One</option>
                            <?php $__currentLoopData = $my_banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $my_bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($my_bank->id); ?>"><?php echo e($my_bank->bank_name); ?> / <?php echo e($my_bank->number); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <button class="btn btn-primary d-block btn-user w-100" type="submit" style="border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Withdraw</button>
                    <hr>
                </form>
            </div>
            <?php else: ?>
            <span>If Amount Greater Than ( > ) 500 Then  you can send Withdrawal Request Button.</span>
            <?php endif; ?>
        </td>
    </tr>
</table>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function () {

        $(function () {
            $('#WalletAddressform').validate({
                rules: {
                    amount: {
                        digits: true,
                        required: true,
//                        lessThan: "#amount_main"
                    }
                },
                messages: {
                    amount: "Enter Only Number Without Sign and Symbol..",
                },
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
        $(document).on('blur', '#amount_count', function () {
            $.ajax({
                url: "<?php echo e(URL::asset('wallet/checkcashrequest')); ?>",
                data: {'value': $(this).val()},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    $(document).find('#amount_count_2').val(data.amount);
                },
                cache: false,
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/withdrawalpage.blade.php ENDPATH**/ ?>