<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
        <title>MalaysianTrade</title>
        <link href="<?php echo e(asset('plugins/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet" type="text/css">
        <link rel="stylesheet" href="<?php echo e(asset('css/sb-admin-2.min.css')); ?>">
        <!--<link rel="stylesheet" href="<?php echo e(asset('plugins/bootstrap/css/bootstrap.min.css')); ?>">-->
        <!--<link rel="stylesheet" href="<?php echo e(asset('fonts/fontawesome-all.min.css')); ?>">-->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">
        <!--<link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">-->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
        <link rel="shortcut icon" href="<?php echo e(asset('images/logo.png')); ?>" />
        <style>
            body, #wrapper, #content-wrapper{
                background-color: #fff !important;
                color: #9352f5 !important;
            }
            #content-wrapper{
                padding:10px;
            }
            .card {
                background-color: #fff;
                border: none;
            }
            .card-header {
                background-color: #1c1c1c;
                color: #9352f5 !important;
            }
            .card-header p {
                background-color: #1c1c1c;
                color: #f1f1f1 !important;
                font-size: 20px;
            }
            .card:hover {
                border: 1px solid #f0b90b;
                transition: border 0.3s ease;
            }
            .card-title {
                color: #000;
            }
            .sidebar,.bg-dark {
                height: auto !important;
                background-color: #fff !important;
            }
            /* Hover and active state */
            .sidebar a:hover,
            .sidebar a.active,
            .sidebar .nav-item.active > a {
                background-color: #2b2e35 !important;
                color: #fff !important;
                border-left: 3px solid #f0b90b !important;
            }

            /* Default link style */
            .sidebar a,
            .sidebar .nav-link {
                color: #000 !important;
                text-decoration: none !important;
                display: block !important;
                padding: 12px 20px !important;
            }
            .sidebar-dark .nav-item .nav-link i {
                color: #000;
            }

            .btn-warning{
                background-color:#ffc107;
                color:#000;
            }
            .btn-success{
                background-color:#ffc107;
                color:#000;
            }

            .form-control-user{
                border-radius: 8px !important;
            }
            form .error {
                color:red;
                font-size:15px;
                width:100%;
            }
            .submit_btn{
                border-radius: 8px !important;
                background: #4f7bf9;
                font-size: 16.8px !important;
                height: 39.1875px !important;
                padding-top: 0px !important;
                padding-bottom: 0px !important;
            }
            .logo_img{
                height:70px;
            }
            @media (min-width: 150px) and (max-width: 600px) {
                .logo_img{
                    height:30px;
                }
                .walletrow .hidonmobile{
                    display:none !important;
                }
                .walletrow .text-xs {
                    font-size: .4rem !important;
                }
                .walletrow .h5 {
                    font-size: 0.9rem !important;
                }
                .walletrow .firstbox {
                    padding-left:8px !important;
                }
                .walletrow .lastbox {
                    padding-right:8px !important;
                }
                .walletrow .col-4 {
                    padding: 3px;
                }
                .walletrow .card-body {
                    padding: 0.5rem;
                }
            }
            .modal-content{
                background: #181A20;
            }
        </style>

        <!-- DataTables -->
        <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">

        <link rel="stylesheet" href="<?php echo e(asset('plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/summernote/summernote-bs4.min.css')); ?>">
        <?php echo $__env->yieldContent('css'); ?>
        <style>
            table.table-bordered.dataTable th{
                color: #F15B41;
            }
            .table-striped tbody tr:nth-of-type(even)
            {
                background-color:#fff !important;
                color: #000;
            }
            .table-striped tbody tr:nth-of-type(odd)
            {
                background-color:#fff !important;
                color: #000;
            }
            .text-gray-800 {
                color: #000 !important;
            }
            .tab-content {
                background: none; 
            }
        </style>
    </head>
    <body id="page-top">
        <!-- Page Wrapper -->
        <div id="wrapper">
            <!-- Sidebar -->
            <ul class="change_menu navbar-nav sidebar sidebar-dark accordion" id="accordionSidebar" style="background: rgb(255,255,255);">
                <!-- Sidebar - Brand -->
                <a class="navbar-brand d-flex justify-content-center align-items-center sidebar-brand m-0" href="#" style="height: 140px;">
                    <div class="sidebar-brand-icon rotate-n-15" style="transform: rotate(0deg);">
                        <img src="<?php echo e(asset('images/logo.png')); ?>" class="logo_img">
                    </div>
                </a>
                <!-- Divider -->
                <hr class="sidebar-divider my-0">
                <!-- Nav Item - Dashboard -->

                <li class="nav-item <?php echo e(Request::is('home*')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('home')); ?>">
                        <i class="fas fa-fw fa-tachometer-alt"></i>
                        <span>Dashboard</span></a>
                </li>

                <?php if(\Auth::user()->role == 1 || \Auth::user()->role == 3): ?>
                <?php
                if (\Auth::user()->role == 1) {
                    $menu = App\User::rightlist();
                    $menu = array_keys($menu);
                } else {
                    $menu = @unserialize(\Auth::user()->rights) ? unserialize(\Auth::user()->rights) : array();
                }
                ?>
                <?php if(in_array('subadmin',$menu)): ?>
                <li class="nav-item <?php echo e(Request::is('subadmin')? 'active' : ''); ?>" >
                    <a class="nav-link" href="<?php echo e(asset('subadmin')); ?>">
                        <i class="fas fa-user-check"></i>
                        <span>Sub Admin Manage</span></a>
                </li>
                <?php endif; ?>
                <?php if(in_array('addnewuser',$menu)): ?>
                <li class="nav-item <?php echo e(Request::is('usermanage/addnew')? 'active' : ''); ?>" >
                    <a class="nav-link" href="<?php echo e(asset('usermanage/addnew')); ?>">
                        <i class="fas fa-user-check"></i>
                        <span>Add User</span></a>
                </li>
                <?php endif; ?>
                <?php if(in_array('usermanage',$menu)): ?>
                <li class="nav-item <?php echo e(Request::is('usermanage')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('usermanage')); ?>">
                        <i class="fas fa-users"></i>
                        <span>User Management</span></a>
                </li>
                <li class="nav-item <?php echo e(Request::is('kyc')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('kyc')); ?>">
                        <i class="fas fa-users"></i>
                        <span>KYC Request</span></a>
                </li>
                <?php endif; ?>
                <?php if(in_array('levelreport',$menu)): ?>
                <li class="nav-item <?php echo e(Request::is('reports/teamtree')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('reports/teamtree')); ?>">
                        <i class="fas fa-sitemap"></i>
                        <span>Level Report</span></a>
                </li>
                <?php endif; ?>
                <li class="d-none nav-item <?php echo e(Request::is('topuppackages/topuppackage')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('topuppackages/topuppackage')); ?>">
                        <i class="fas fa-user"></i>
                        <span>Member Top-up</span>
                    </a>
                </li>
                <?php if(in_array('packages',$menu)): ?>
                <li class="nav-item <?php echo e(Request::is('packages')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('packages')); ?>">
                        <i class="fas fa-list-alt"></i>
                        <span>Packages</span></a>
                </li>
                <?php endif; ?>
                <?php if(in_array('packagerequest',$menu)): ?>
                <li class="nav-item <?php echo e(Request::is('topuppackages/requestslist')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('topuppackages/requestslist')); ?>">
                        <i class="fas fa-wallet"></i>
                        <span>Package Requests</span></a>
                </li>
                <?php endif; ?>
                <li class="d-none nav-item <?php echo e(Request::is('wallet/memberpackagereport')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('wallet/memberpackagereport')); ?>">
                        <i class="fas fa-list-alt"></i>
                        <span>Member Package Report</span></a>
                </li>
                <li class="d-none nav-item <?php echo e(Request::is('reports/tripachievers')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('reports/tripachievers')); ?>">
                        <i class="fas fa-arrow-right"></i>
                        <span>Trip Achievers</span></a>
                </li>
                <li class="nav-item <?php echo e(Request::is('reports/myteam') || Request::is('reports/referralin*') || Request::is('reports/roiincome*') || Request::is('reports/consolidated*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilitiesteam"
                       aria-expanded="true" aria-controls="collapseUtilitiesteam">
                        <i class="fas fa-list"></i>
                        <span>Reports</span>
                    </a>
                    <div id="collapseUtilitiesteam" class="collapse <?php echo e(Request::is('reports/myteam')  || Request::is('reports/referralinc*') || Request::is('reports/consolidated*') || Request::is('reports/roiincome*')? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('reports/myteam*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/myteam')); ?>">Level Report</a>
                            <a class="collapse-item <?php echo e(Request::is('reports/roiincome*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/roiincome')); ?>">ROI Report</a>
                            <a class="collapse-item <?php echo e(Request::is('reports/referralincome*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/referralincomeall')); ?>">Level on ROI Report</a>
                            <a class="collapse-item <?php echo e(Request::is('reports/consolidated*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/consolidated')); ?>">Consolidated Payout</a>
                        </div>
                    </div>
                </li>
                <li class="nav-item <?php echo e(Request::is('wallet/cashrequestadmin')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('wallet/cashrequestadmin')); ?>">
                        <i class="fas fa-wallet"></i>
                        <span>Withdrawal Request</span></a>
                </li>
                <li class="nav-item <?php echo e(Request::is('wallet/*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#PayoutReports"
                       aria-expanded="true" aria-controls="collapseUtilities">
                        <i class="fas fa-money-bill-alt"></i>
                        <span>Payout Reports</span>
                    </a>
                    <div id="PayoutReports" class="collapse <?php echo e(Request::is('wallet/*')? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('wallet/paymentform*')? 'active' : ''); ?>" href="<?php echo e(asset('wallet/paymentform')); ?>">Payment - Form</a>
                            <a class="collapse-item <?php echo e(Request::is('wallet/payouthistory*')? 'active' : ''); ?>" href="<?php echo e(asset('wallet/payouthistory')); ?>">Payout Report</a>
                        </div>
                    </div>
                </li>
                <li class="d-none nav-item">
                    <a href="<?php echo e(asset('support/requestlist')); ?>" class="nav-link <?php echo e(Request::is('support/requestlist')? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-question-circle"></i>
                        <span>Support Message</span>
                        <span class="badge badge-danger right" style="font-size: 0.6rem;"><?php echo e(\App\Support::where('flag',0)->get()->count() + \App\SupportComment::where('user_id', '!=', \Auth::user()->id)->where('flag', 0)->get()->count()); ?></span>
                    </a>
                </li>
                <?php if(in_array('packages',$menu)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(asset('pagemanage/faqs')); ?>" class="nav-link <?php echo e(Request::is('pagemanage/faqs*')? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <span>Faq's</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(in_array('termcondition',$menu)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(asset('pagemanage/termcondition')); ?>" class="nav-link <?php echo e(Request::is('pagemanage/termcondition*')? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <span>Term Condition</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(in_array('privacypolicy',$menu)): ?>
                <li class="nav-item">
                    <a href="<?php echo e(asset('pagemanage/privacypolicy')); ?>" class="nav-link <?php echo e(Request::is('pagemanage/privacypolicy*')? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <span>Privacy Policy</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php endif; ?>

                <?php if(\Auth::user()->role == 2): ?>
                <li class="nav-item <?php echo e(Request::is('usermanage/profile')? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(asset('usermanage/profile')); ?>">
                        <i class="fas fa-user"></i>
                        <span>My Profile</span></a>
                </li>
                <li class="nav-item <?php echo e(Request::is('reports/myteam') || Request::is('reports/mydirects*') || Request::is('reports/myandb*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilitiesteam"
                       aria-expanded="true" aria-controls="collapseUtilitiesteam">
                        <i class="fas fa-users"></i>
                        <span>My team</span>
                    </a>
                    <div id="collapseUtilitiesteam" class="collapse <?php echo e(Request::is('reports/myteam') || Request::is('reports/teamtree') || Request::is('reports/myandb*') || Request::is('reports/mydirects')? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('reports/mydirects')? 'active' : ''); ?>" href="<?php echo e(asset('reports/mydirects')); ?>">My Direct</a>
                            <!--<a class="collapse-item <?php echo e(Request::is('reports/teamtree')? 'active' : ''); ?>" href="<?php echo e(asset('reports/teamtree')); ?>">Direct Tree</a>-->
                            <a class="collapse-item <?php echo e(Request::is('reports/myteam*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/myteam')); ?>">Level Report</a>
                            <a class="collapse-item <?php echo e(Request::is('reports/myandb*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/myandb')); ?>">My ABC</a>
                        </div>
                    </div>
                </li>
                <li class="nav-item <?php echo e(Request::is('topuppackagese*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilities"
                       aria-expanded="true" aria-controls="collapseUtilities">
                        <i class="fas fa-wallet"></i>
                        <span>Invest</span>
                    </a>
                    <div id="collapseUtilities" class="collapse <?php echo e(Request::is('topuppackages*')? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('topuppackages/memberactivation') || Request::is('topuppackages/purchase*')? 'active' : ''); ?>" href="<?php echo e(asset('topuppackages/memberactivation')); ?>">Top Up</a>
                            <a class="collapse-item <?php echo e(Request::is('topuppackages/mypackages')? 'active' : ''); ?>" href="<?php echo e(asset('topuppackages/mypackages')); ?>">My Invest</a>
                            <a style="display:none;" class="collapse-item <?php echo e(Request::is('topuppackages/myinvoice')? 'active' : ''); ?>" href="<?php echo e(asset('topuppackages/myinvoice')); ?>">My Invoice</a>
                        </div>
                    </div>
                </li>
                <li class="nav-item <?php echo e(Request::is('wallet/*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#PayoutReports"
                       aria-expanded="true" aria-controls="collapseUtilities">
                        <i class="fas fa-money-bill-alt"></i>
                        <span>Wallet</span>
                    </a>
                    <div id="PayoutReports" class="collapse <?php echo e(Request::is('wallet/*')? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('wallet/allwalletreport*')? 'active' : ''); ?>" href="<?php echo e(asset('wallet/allwalletreport')); ?>">Wallet Report</a>
                            <a class="collapse-item <?php echo e(Request::is('wallet/withdrawalrequest*')? 'active' : ''); ?>" href="<?php echo e(asset('wallet/withdrawalrequest')); ?>">Withdraw Request</a>
                            <a class="collapse-item <?php echo e(Request::is('wallet/withdrawalreport*')? 'active' : ''); ?>" href="<?php echo e(asset('wallet/withdrawalreport')); ?>">Withdrawal Report </a>
                        </div>
                    </div>
                </li>
                
                <li class="nav-item <?php echo e(Request::is('reports/roiincome') || Request::is('reports*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilitiesincome" aria-expanded="true" aria-controls="collapseUtilities">
                        <i class="bi bi-currency-rupee"></i>
                        <span>My Income</span>
                    </a>
                    <div id="collapseUtilitiesincome" class="collapse <?php echo e(Request::is('reports*') || Request::is('reports/roiincome') || Request::is('reports/referralincome*')? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('reports/directincome*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/directincome')); ?>">Direct Income</a>
                            <a class="collapse-item <?php echo e(Request::is('reports/roiincome')? 'active' : ''); ?>" href="<?php echo e(asset('reports/roiincome')); ?>">Daily ROI</a>
                            <a class="collapse-item <?php echo e(Request::is('reports/referralincome*')? 'active' : ''); ?>" href="<?php echo e(asset('reports/referralincome/'.\Auth::user()->id)); ?>">Level On ROI</a>
                            <a class="collapse-item <?php echo e(Request::is('reports/referralincome*')? 'active' : ''); ?>" href="#">Consolidated Report</a>
                            <!--<a class="d-none collapse-item <?php echo e(Request::is('reports/goldmining')? 'active' : ''); ?>" href="<?php echo e(asset('reports/goldmining')); ?>">Gold Mining Direct</a>-->
                            <!--<a class="collapse-item <?php echo e(Request::is('reports/goldminingteam')? 'active' : ''); ?>" href="<?php echo e(asset('reports/goldminingteam')); ?>">Gold Mining Team</a>-->
                            <a class="collapse-item <?php echo e(Request::is('reports/awardreward')? 'active' : ''); ?>" href="<?php echo e(asset('reports/awardreward')); ?>">Award & Reward</a>
                        </div>
                    </div>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#"><i class="bi bi-trophy"></i> My Bonanza</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#"><i class="bi bi-flag"></i> My Contest</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#submenuCompany" aria-expanded="true" aria-controls="submenuCompany">
                        <span><i class="bi bi-building"></i> Company Info</span>
                    </a>
                    <ul class="list-unstyled ps-4 collapse" id="submenuCompany" style="">
                        <li><a class="nav-link" href="#">Deposit Info</a></li>
                        <li><a class="nav-link" href="#">Company Presentation</a></li>
                        <li><a class="nav-link" href="#">FAQs</a></li>
                    </ul>
                </li>
                <li class="d-none nav-item <?php echo e(Request::is('wallet/withdrawalrequest') || Request::is('wallet/withdrawalreport')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilitiesWithdrawal"
                       aria-expanded="true" aria-controls="collapseUtilities">
                        <i class="fas fa-wallet"></i>
                        <span>Withdrawal</span>
                    </a>
                    <div id="collapseUtilitiesWithdrawal" class="collapse <?php echo e(Request::is('wallet/withdrawalrequest') || Request::is('wallet/withdrawalreport')? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('wallet/withdrawalrequest*')? 'active' : ''); ?>" href="<?php echo e(asset('wallet/withdrawalrequest')); ?>">Withdrawal Request</a>
                            <a class="collapse-item <?php echo e(Request::is('wallet/withdrawalreport')? 'active' : ''); ?>" href="<?php echo e(asset('wallet/withdrawalreport')); ?>">Withdrawal Report</a>
                        </div>
                    </div>
                </li>
                <li class="nav-item <?php echo e(Request::is('mydocs*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilitiesdocs"
                       aria-expanded="true" aria-controls="collapseUtilities">
                        <i class="fas fa-file"></i>
                        <span>Documents</span>
                    </a>
                    <div id="collapseUtilitiesdocs" class="collapse <?php echo e(Request::is('mydocs*') ? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('kyc')? 'active' : ''); ?>" href="<?php echo e(asset('kyc')); ?>">KYC</a>
                            <!--<a class="collapse-item <?php echo e(Request::is('mydocs/welcome')? 'active' : ''); ?>" href="<?php echo e(asset('mydocs/welcome')); ?>">Welcome Letter</a>-->
                            <!--<a class="collapse-item <?php echo e(Request::is('mydocs/idcard')? 'active' : ''); ?>" href="<?php echo e(asset('mydocs/idcard')); ?>">ID Card</a>-->
                        </div>
                    </div>
                </li>
                <li class="d-none nav-item <?php echo e(Request::is('mydocs*')? 'active' : ''); ?>">
                    <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseUtilitiesdocs"
                       aria-expanded="true" aria-controls="collapseUtilities">
                        <i class="fas fa-file"></i>
                        <span>My Docs</span>
                    </a>
                    <div id="collapseUtilitiesdocs" class="collapse <?php echo e(Request::is('mydocs*') ? 'show' : ''); ?>" aria-labelledby="headingUtilities" data-parent="#accordionSidebar">
                        <div class="bg-dark py-2 collapse-inner rounded">
                            <a class="collapse-item <?php echo e(Request::is('mydocs/welcome')? 'active' : ''); ?>" href="<?php echo e(asset('mydocs/welcome')); ?>">Welcome Letter</a>
                            <!--<a class="collapse-item <?php echo e(Request::is('mydocs/idcard')? 'active' : ''); ?>" href="<?php echo e(asset('mydocs/idcard')); ?>">ID Card</a>-->
                        </div>
                    </div>
                </li>
                <li class="d-none nav-item">
                    <a href="<?php echo e(asset('support/message')); ?>" class="nav-link <?php echo e(Request::is('support/message*') ? 'active' : ''); ?>">
                        <i class="far fa-circle"></i>
                        <?php $support = \App\Support::where('user_id', \Auth::user()->id)->pluck('id', 'id')->all(); ?>
                        <span>Support Message</span>
                        <span class="badge badge-danger right" style="font-size: 0.6rem;"><?php echo e(\App\SupportComment::where('flag',0)->where('user_id', '!=', \Auth::user()->id)->whereIn('support_id',$support)->get()->count()); ?></span>
                    </a>
                </li>
                <li class="nav-item d-none">
                    <a href="<?php echo e(asset('page/term')); ?>" class="nav-link <?php echo e(Request::is('page/term*')? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-list"></i>
                        <span>
                            Terms & Conditions  
                        </span>
                    </a>
                </li>
                <li class="nav-item d-none">
                    <a href="<?php echo e(asset('page/privacy')); ?>" class="nav-link <?php echo e(Request::is('page/privacy')? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-user-secret"></i>
                        <span>
                            Privacy Policy  
                        </span>
                    </a>
                </li>
                <?php endif; ?>
                <br>
                <?php if(Auth::user()->email_verified_at != null): ?>
                <hr class="sidebar-divider">
                <!-- Sidebar Toggler (Sidebar) -->
                <div class="text-center d-none d-md-inline">
                    <button class="btn bg-secondary bg-gradient rounded-circle border-0" id="sidebarToggle"></button>
                </div>
                <?php endif; ?>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                    <?php echo csrf_field(); ?>
                </form>
                <button class="btn btn-warning" onclick="event.preventDefault();document.getElementById('logout-form').submit();"><i class="bi bi-box-arrow-right"></i> Logout</button>
            </ul>
            <!-- End of Sidebar -->
            <!-- Content Wrapper -->
            <div id="content-wrapper" class="d-flex flex-column ms-sm-auto px-md-4 mt-4">
                <!-- Main Content -->
                <div id="content" class="">

                    <nav class="d-none navbar navbar-light navbar-expand bg-dark shadow mb-4 topbar static-top" style="height: auto;">
                        <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                            <i class="fa fa-bars"></i>
                        </button> 
                        <ul class="navbar-nav ml-auto">
                            <div class="topbar-divider d-none d-sm-block"></div>
                            <!-- Nav Item - User Information -->
                            <li class="nav-item dropdown no-arrow">
                                <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                                   data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="mr-2 d-none d-lg-inline text-gray-600 small"><?php echo e(\Auth::user()->name); ?> <?php echo e(\Auth::user()->last_name); ?></span>
                                    <?php if(\Auth::user()->profile_image): ?>
                                    <img class="img-profile rounded-circle" src="<?php echo e(asset('images/blank_user.png')); ?>">
                                    <!--<img class="img-profile rounded-circle" src="<?php echo e(asset('profile_image/'.\Auth::user()->profile_image)); ?>">-->
                                    <?php else: ?>
                                    <img class="img-profile rounded-circle" src="<?php echo e(asset('images/blank_user.png')); ?>">
                                    <?php endif; ?>
                                </a>
                                <!-- Dropdown - User Information -->
                                <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                                    <a class="dropdown-item" href="<?php echo e(asset('usermanage/profile')); ?>">
                                        <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                        Profile
                                    </a>
                                    <a class="dropdown-item" href="<?php echo e(asset('usermanage/changepassword')); ?>">
                                        <i class="fas fa-key fa-sm fa-fw mr-2 text-gray-400"></i>
                                        Passwords
                                    </a>
                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                               document.getElementById('logout-form').submit();">
                                        <i class="fas fa-sign-out-alt fa-sm fa-fw me-2 text-gray-400"></i> <?php echo e(__('Logout')); ?>

                                    </a>
                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
                        </ul>
                    </nav>

                    <!-- End of Topbar -->
                    <!-- Begin Page Content --                >
                    <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="">
                        <?php if(\Session::get('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            <?php echo e(\Session::get('success')); ?>

                        </div>
                        <?php endif; ?>
                        <?php if(\Session::get('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-exclamation-triangle"></i> Error!</h5>
                            <?php echo e(\Session::get('error')); ?>

                        </div>
                        <?php endif; ?>
                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <p><strong>Opps Something went wrong</strong></p>
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>
                        <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3" style="color:#000;font-size: 24px;text-decoration: none;">
                            <i class="fa fa-bars"></i> Menu
                        </button> 
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
                <!--            /.container-fluid -->
            </div>
            <!-- End of Main Content -->
        </div>
        <!-- Footer -->
        <footer class="sticky-footer bg-dark d-none">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; MalaysianTrade <?php echo e(date('Y')); ?></span>
                </div>
            </div>
        </footer>
        <!-- Endof Footer -->

        <!-- End of Content Wrapper -->

        <!-- End of Page Wrapper -->

        <!-- Scroll to Top Button-->
        <a class="scroll-to-top rounded" href="#page-top">
            <i class="fas fa-angle-up"></i>
        </a>

        <!-- Bootstrap core JavaScript-->
        <script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
        <!-- Core plugin JavaScript-->
        <script src="<?php echo e(asset('plugins/jquery-easing/jquery.easing.min.js')); ?>"></script>
        <!-- Custom scripts for all pages-->
        <script src="<?php echo e(asset('js/sb-admin-2.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/jquery.validate.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/additional-methods.min.js')); ?>"></script>

        <!-- DataTables  & Plugins -->
        <script src="<?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
        <script src="https://cdn.datatables.net/buttons/2.2.3/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
        <!-- SweetAlert2 -->
        <script src="<?php echo e(asset('plugins/sweetalert2/sweetalert2.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/summernote/summernote-bs4.min.js')); ?>"></script>
        <script>
                                           $(document).ready(function () {
                                               $.ajaxSetup({
                                                   headers: {
                                                       'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                                   }
                                               });
                                           });
        </script>
        <?php echo $__env->yieldContent('script'); ?>
    </body>
</html><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/layouts/user.blade.php ENDPATH**/ ?>