
<?php $__env->startSection('css'); ?>
<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Consolidated Report</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <form class="form-inline">
            <div class="form-group">
                <label>Select Date </label>
                <select name="date"  class="form-control"  title="Select Member">
                    <option value="no_date">No Date All Day Total</option>
                    <?php $__currentLoopData = $dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($date->format('Y-m-d')); ?>" <?= request('date') == $date->format('Y-m-d') ? 'selected' : '' ?>>
                        <?php echo e($date->format('d-m-Y')); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <button type="submit" class="btn btn-success">Find</button>
        </form>
    </div>
</div>
<br>
<br>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="Datatable_2" class="table table-bordered table-striped">
                        <thead>
                            <tr class="seprator">
                                <th>Sr.No</th>
                                <?php if(request('date')): ?>
                                <th>Date</th>
                                <?php endif; ?>
                                <th>Member Id</th>
                                <th>Member Name</th>
                                <th>ROI</th>
                                <th>Level On ROI</th>
                                <th>Total Payout</th>
                                <th>TDS</th>
                                <th>Admin Charges</th>
                                <th>Net Payment</th>
                                <th>Amount Paid</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $selected = request('date') ? date('d-m-Y', strtotime(request('date'))) : '';
                            ?>
                            <tr>
                                <td><?php echo e($i); ?></td>
                                <?php if(request('date')): ?>
                                <td><?php echo e($selected); ?></td>
                                <?php endif; ?>
                                <td><?php echo e($row->username); ?></td>
                                <td><?php echo e($row->name); ?></td>
                                <td>
                                    <?php
                                    if (!request('date')) {
                                        $roi = \App\RoiIncome::where('user_id', $row->id)->where('status', 1)->sum('amount');
                                        $levelroi = \App\ReferralRoi::where('user_id', $row->id)->where('status', 1)->sum('amount');
                                    } else {
                                        $roi = \App\RoiIncome::where('user_id', $row->id)->where('status', 1)->where('date', date('Y-m-d', strtotime($selected)))->sum('amount');
                                        $levelroi = \App\ReferralRoi::where('user_id', $row->id)->where('status', 1)->where('date', date('Y-m-d', strtotime($selected)))->sum('amount');
                                    }
                                    ?>
                                    <?php echo e(App\WalletRequest::amountFormat($roi)); ?>

                                </td>
                                <td>
                                    <?php echo e(App\WalletRequest::amountFormat($levelroi)); ?>

                                </td>
                                <td><?php echo e(App\WalletRequest::amountFormat($roi+$levelroi)); ?></td>
                                <td><?php echo e(App\WalletRequest::amountFormat(round(($roi+$levelroi)*5/100,2))); ?></td>
                                <td><?php echo e(App\WalletRequest::amountFormat(round(($roi+$levelroi)*5/100,2))); ?></td>
                                <td><?php echo e(App\WalletRequest::amountFormat(($roi+$levelroi)-round(($roi+$levelroi)*10/100,2))); ?></td>
                                <?php $recive = App\Wallet::where('user_id', $row->id)->where('flag', 1)->sum('total_amount'); ?>
                                <td><?php echo e(App\WalletRequest::amountFormat($recive)); ?></td>
                            </tr>
                            <?php $i++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    var tabledata = $('#Datatable').DataTable();
    var tabledata2 = $('#Datatable_2').DataTable();
    var tabledata3 = $('#Datatable_3').DataTable();

    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Reject Reason",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reject it!',
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value != '') {
                        resolve()
                    } else {
                        resolve('Reason Required...')
                    }
                })
            }
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo e(URL::asset('wallet/rejecteentry')); ?>",
                    data: {'row_id': $(this).attr('id'), 'reason': result.value},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.approved_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Text",
            icon: 'success',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Approve it!',
        }).then((result) => {
            $.ajax({
                url: "<?php echo e(URL::asset('wallet/approveentry')); ?>",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        });
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/consolidated.blade.php ENDPATH**/ ?>