
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card shadow mb-3">
            <div class="card-header py-3">
                <p class="text-primary m-0 fw-bold">Bank Account Information
                    <button class="btn btn-info btn-sm float-right" id="openaddmodel">
                        Add More Bank <i class="fas fa-plus"></i>
                    </button>
                </p> 

            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="Datatable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Payee Name</th>
                                <th>Account Number</th>
                                <th>Bank Name</th>
                                <th>Branch Name</th>
                                <th>IFSC Code</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card shadow mb-3">
    <div class="card-header py-3">
        <p class="text-primary m-0 fw-bold">Document Upload
        </p> 
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-sm-6">
                <?php if(count($errors) > 0): ?>
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
                <div class="fd p_lr_15 m_t_15">
                    <form class="fd p_b_15 form_cord" enctype="multipart/form-data" method="POST" action="<?php echo e(asset('kyc/upload')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label>Select Doc. Type</label>
                            <select class="form-control" name="type" required>
                                <option value="PAN Card"> PAN Card </option>
                                <option value="Aadhar Card"> Aadhar Card </option>
                                <option value="Driving licence"> Driving licence </option>
                            </select>
                        </div>
                        <div class="form-group">
                            <input type="file" name="file" required/>
                            <small class="form-text text-muted">*Upload Only PNG, JPG, JPGE Files</small>
                        </div>
                        <div class="form-group">
                            <button class="btn  btn-primary m_r_10" type="submit">
                                Upload
                            </button>
                            <button class="btn btn-danger">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-12">
        <h4>Uploaded Documents history</h4>
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr class="seprator">
                        <th>Sr No </th>
                        <th>Uploaded date </th>
                        <th>Document type </th>
                        <th>View Document </th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php $__currentLoopData = $kycs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td> <?php echo e($i); ?> </td>
                        <td> <?php echo e(date('d M Y',strtotime($kyc->created_at))); ?></td>
                        <td> <?php echo e($kyc->type); ?> </td>
                        <td title="View Document" class="pointer">
                            <a href="" data-toggle="modal" data-target="#exampleModal<?php echo e($kyc->id); ?>">
                                <i class="fa fa-eye" aria-hidden="true" ></i>
                            </a>
                            <div class="modal fade" id="exampleModal<?php echo e($kyc->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <img src="<?php echo e(asset('kyc_doc/'.$kyc->file)); ?>" style="max-width:400px;"/>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td> 
                            <?php if($kyc->status == 0): ?>
                            <span class="text-warning">Pending</span>
                            <?php elseif($kyc->status == 1): ?>
                            <span class="text-success">Success</span>
                            <?php else: ?>
                            <span class="text-danger">Rejected</span>
                            <a class="btn btn-sm btn-danger" href="<?php echo e(asset('kyc/rejecteddelete/'.$kyc->id)); ?>"><i class="fas fa-trash-alt"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="modal fade" id="openaddmodelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Bank Account Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(asset('usermanage/savebankdetails/'.$user->id)); ?>" id="quickForm" method="post">
                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />
                <input type="hidden" name="update_id" value="" />
                <div class="modal-body">
                    <div class="row">
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="Payee Name" name="payee_name" required />
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-user" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="Account Number " name="account_number" required/>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-id-card" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <select class="form-control" name="bank_name" id="bank" required>
                                <option> Select Bank </option>
                                <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($bank->name); ?>" ><?php echo e($bank->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-university" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="Branch" name="branch" required />
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <i class="fa fa-map-marker" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3 col-sm-6">
                            <input type="txt" class="form-control" placeholder="IFSC Code"  name="ifsc" required/>
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save Data</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function () {
        $(document).on('click', '#openaddmodel', function () {
            $('#openaddmodelModal').modal('show');
        });
    });
    var tabledata = $('#Datatable').DataTable({
            processing: true,
            serverSide: true,
            ajax: '<?php echo e(asset("usermanage/bankdata/".$user->id)); ?>',
            columns: [
                {data: 'holder_name', name: 'holder_name'},
                {data: 'number', name: 'number'},
                {data: 'bank_name', name: 'bank_name'},
                {data: 'branch_name', name: 'branch_name'},
                {data: 'ifsc_code', name: 'ifsc_code'},
                {data: 'action', name: 'action', orderable: false, searchable: false, width: '100px'}
            ]
        });
        $(document).on('click', '.delete_btn', function () {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#17a2b8',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?php echo e(asset("usermanage/savebankdetails/".$user->id)); ?>',
                        data: {delete_row: 'delete_row', 'row_id': $(this).attr('id')},
                        type: "POST",
                        headers: {
                            'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                        },
                        success: function (data)
                        {
                            tabledata.draw();
                        },
                        cache: false,
                    });
                }
            });
        });
        $(document).on('click', '.update_btn', function () {
            $.ajax({
                url: '<?php echo e(asset("usermanage/savebankdetails/".$user->id)); ?>',
                data: {edit_data: 'edit_data', 'row_id': $(this).attr('id')},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    $(document).find("input[name='update_id']").val(data.row.id);
                    $(document).find("input[name='payee_name']").val(data.row.holder_name);
                    $(document).find("input[name='account_number']").val(data.row.number);
                    $(document).find("select[name='bank_name']").val(data.row.bank_name);
                    $(document).find("input[name='branch']").val(data.row.branch_name);
                    $(document).find("input[name='ifsc']").val(data.row.ifsc_code);
                    $('#openaddmodelModal').modal('show');
                },
                cache: false,
            });
        });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/kyc.blade.php ENDPATH**/ ?>