<?php

use Illuminate\Support\Facades\Route;

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
 */

//Auth::routes(['verify' => true]);
Auth::routes(['verify' => false]);

Route::get('/', function () {
    if (\Auth::user()) {
        return \Redirect::to('home');
    }
    return view('auth.login');
});

Route::get('cashwalletcron', function () {
    if (\Auth::user()) {
        $data['text'] = 'Not Run Only Tuesday....';
        if (date('D') == 'Tue') {
            $check = App\CheckCron::whereDate('created_at', date('Y-m-d'))->where('text', 'cash wallet Cron')->first();
            if ($check) {
                $data['text'] = 'Today Already Run....';
            } else {
                \Artisan::call('cashwallet:cron');
                $data['text'] = 'Run Success...';
            }
        } else {
            $data['text'] = 'Not Run Only Tuesday....';
        }
        return view('admin.cashwalletcron', $data);
    }
    return \Redirect::to('/');
});

Route::post('packagedetails', 'HomeController@packagedetails')->name('packagedetails');



//Route::group(['middleware' => 'verified'], function() {
Route::get('/home', 'HomeController@index')->name('home');
AdvancedRoute::controller('frontdata', 'HomeController');

AdvancedRoute::controller('usermanage', 'UserManageController');
AdvancedRoute::controller('kyc', 'KycController');
AdvancedRoute::controller('subadmin', 'SubAdminManageController');
AdvancedRoute::controller('packages', 'ProductController');
AdvancedRoute::controller('topuppackages', 'TopUpController');
AdvancedRoute::controller('reports', 'ReportsController');
AdvancedRoute::controller('mydocs', 'ReportsController');
AdvancedRoute::controller('wallet', 'WalletController');
AdvancedRoute::controller('support', 'SupportController');
AdvancedRoute::controller('page', 'SupportController');
AdvancedRoute::controller('pagemanage', 'PagesManageController');
//});
