@extends('layouts.user')

@section('content')
<div class="row">
    <div class="col-lg-7">
        <div class="">
            <h4 class="fw-bolder text-dark mb-4"><b>Open/Close Withdrawal Request For User</b></h4>
        </div>
        <form method="POST" enctype="multipart/form-data" action="{{ asset('pagemanage/savegoldprive') }}" class="user" id="purchaseform">
            @csrf
            <div class="form-group form-inline">
                <select class="form-control" name="withdrawal_btn">
                    <option value="0" <?=$user->withdrawal_btn == 0?'selected':''?>>Off</option>
                    <option value="1" <?=$user->withdrawal_btn == 1?'selected':''?>>On</option>
                </select>
                <button class="btn btn-primary" type="submit" style="margin-left:10px; border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Save Changes</button>
            </div>
        </form>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-lg-7">
        <div class="">
            <h4 class="fw-bolder text-dark mb-4"><b>Run Cash Wallet Cron</b></h4>
            <a href="{{asset('cashwalletcron')}}" class="btn btn-warning">Click TO Run</a>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {

        $(function () {
            $('#purchaseform_ss').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
@endsection

