@extends('layouts.user')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-7">
        <div class="text-center">
            <h4 class="fw-bolder text-dark mb-4"><b>Set 1GM Gold Rate</b></h4>
        </div>
        <form method="POST" enctype="multipart/form-data" action="{{ asset('topuppackages/savegoldprive') }}" class="user" id="purchaseform">
            @csrf
            <div class="mb-3">
                <label class="form-label"><strong>Enter Amount</strong></label>
                <input class="form-control form-control-user" type="text" value="{{App\WalletRequest::amountFormat($user->gold_price)}}" placeholder="1GM Amount" name="gold_price" required>
                <span class="help-block" style="font-size:12px;">Example : 71,500</span>
            </div>
            <button class="btn btn-primary d-block btn-user w-100" type="submit" style="border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Save Changes</button>
            <hr>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {

        $(function () {
            $('#purchaseform_ss').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
@endsection

