@extends('layouts.user')
@section('css')
<!-- Theme style -->
<!--<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/style.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/const.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/poppin.css') }}">-->
<style>


</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Income On Level Report : {{$user->username}}</h1>
    <a class="btn btn-info pull-right" href="{{asset('reports/referralincomeall')}}">Back</a>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="ctable">
                        <thead>
                            <tr>
                                <th><strong>S.No </strong></th>
                                <th><strong>Affiliate Name</strong></th>
                                <th><strong>Affiliate ID</strong></th>
                                <th><strong>Level No.</strong></th>
                                <th><strong>Total Amount</strong></th>
                                <th><strong>View</strong></th>
                            </tr>
                        </thead> 
                        <tbody>
                            <?php $j = 1; ?>
                            @foreach($userdetils as $user)
                            @if($user->getreferralid)
                            <tr>
                                <td>{{$j}}</td>
                                <td>{{$user->getreferralid->name}} {{$user->getreferralid->last_name}}</td>
                                <td>{{$user->getreferralid->username}}</td>
                                <td>{{$user->level}}</td>
                                <td>
                                    <?php
                                    $total = \App\ReferralRoi::where('user_id', $user->user_id)->where('referral_id', $user->referral_id)
                                                    ->where('wallet_request_id', $user->wallet_request_id)
                                                    ->where('level', $user->level)->where('status', 1)->sum('net_amount');
                                    ?>
                                    {{App\WalletRequest::amountFormat($total)}}
                                </td>
                                <td><a href="{{asset('reports/referralincomedetails/'.$user->id)}}">View Details</a></td>
                            </tr>
                            <?php $j++; ?>
                            @endif
                            @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div style="clear:both;"></div>
<!-- /.content -->    
@endsection


@section('script')
<script>
    $("#ctable").DataTable();
</script>
@stop
