@extends('layouts.user')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="text-center">
            <h4 class="fw-bolder text-dark mb-4"><b>Invset Amount</b></h4>
        </div>
        <form method="POST" enctype="multipart/form-data" action="{{ asset('topuppackages/purchasesave') }}" class="user" id="purchaseform">
            @csrf
            <div class="mb-3">
                <label class="form-label"><strong>Select TopUp Bank/Wallet</strong></label>
                <select class="form-control" id="changetopup" name="mode" required>
                    <option value="Bank">Bank Transfer</option>
                    <option value="Qr">Scan Qr</option>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Select Package</strong></label>
                <select name="pack_id" class="form-control" required>
                    <option>Select One</option>
                    @foreach($packages as $pack)
                    <option value="{{$pack->id}}">{{$pack->package_name}} / ${{$pack->mrp}}</option>
                    @endforeach
                </select>
            </div>
            <div id="bank_div">
                <div class="mb-3">
                    <label class="form-label"><strong>Enter Transaction ID</strong></label>
                    <input class="form-control form-control-user requiredremove" type="text" placeholder="Transaction ID" name="transaction_id" required>
                </div>
                <div class="mb-3">
                    <label class="form-label"><strong>Upload Transaction Proof</strong></label>
                    <input class="form-control form-control-user requiredremove" type="file" placeholder="Transaction ID" name="payment_proof" accept="image/*" required>
                </div>
            </div>
            <div id="wallet_div" style="display:none;">
                <b>Cash Wallet Balance </b> : {{App\WalletRequest::amountFormat($cash_amount)}}
                <input type="hidden" value="{{$cash_amount}}" id="walletval" />
                <br>
                <br>
            </div>
            <button class="btn btn-primary btn-user w-100" id="submitbtn" type="submit" style="border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Submit</button>
            <hr>
        </form>
    </div>
    <div class="col-lg-6">
        <h4 class="fw-bolder text-dark mb-4"><b>Send Payment This QR</b></h4>
        <img src="{{asset('images/barcode.jpg')}}" style="width:400px;"/>
        <br>
        My Public Address to Receive BNB 0x97dbC7b436256241f1bD185375319FdE8211ED90
        <br>
        <br>
        Pay me via Trust Wallet: <br>https://link.trustwallet.com/send?coin=20000714&address=0x97dbC7b436256241f1bD185375319FdE8211ED90 
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {

        $(document).on('keyup', '#amount_number', function () {
            var amount = parseInt($(this).val());
            var charge = amount * 5 / 100;
            var main = (amount + charge);

            var mm = $(document).find('#walletval').val();

            if (mm < main)
            {
                $(document).find('#amount_number_div').text('Cash Wallet Balance Low Amount+charges 5% =' + main + ' Not Valid');
                $(document).find('#submitbtn').hide();
            } else
            {
                $(document).find('#amount_number_div').text('Cash Wallet Debit Amount + charges 5% after Approved =' + main);
                $(document).find('#submitbtn').show();
            }
        })
        $(document).on('change', '#changetopup', function () {
            if ($(this).val() == 'Wallet')
            {
                $(document).find('#wallet_div').show();
                $(document).find('#amount_number_div').show();
                $(document).find('#bank_div').hide();
                $(document).find('#submitbtn').hide();
                $(document).find('.requiredremove').removeAttr('required');
            } else
            {
                $(document).find('#wallet_div').hide();
                $(document).find('#amount_number_div').hide();
                $(document).find('#bank_div').show();
                $(document).find('#submitbtn').show();
                $(document).find('.requiredremove').attr('required', 'required');
            }
        });

        $(function () {
            $('#btn-upload').click(function (e) {
                e.preventDefault();
                $('#profile_image').click();
            });
        });
        $(document).on('change', '#profile_image', function () {
            $(this).closest('form').submit();
        });

        $(function () {
            $('#registerform').validate({
                rules: {
                    username: {
                        required: true,
                        alphanumeric: true
                    }
                },
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
        $(function () {
            $('#WalletAddressform').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
@endsection

