@extends('layouts.user')
@section('css')
<style>
    .headerrow{
        font-size: 23px;
        color: green;
        margin-bottom: 10px;
    }
</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Level Report</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <form class="form-inline">
            <label>Enter User ID&nbsp;</label>
            <input type="text"  name="usertree" value="{{request('usertree')}}" class="form-control" required/>
            &nbsp;&nbsp;<button type="submit" class="btn btn-success">Get Data</button>
        </form>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-12">
        <!---------------------------- Level 1 start --------------------->
        <?php $i = 1; ?>
        @foreach($levels as $level)
        <?php $list = array_filter($level); ?>
        @if(count($list) > 0)
        <div class="row headerrow">
            <div class="col-md-6">
                <i class="fas fa-info-circle m_r_10"></i> Level {{$i}}
            </div>
            <div class="col-md-6 text-right">
                <i class="fas fa-user-circle"></i> Total {{count($list)}}
            </div>
        </div>
        <div class="fd p_lr_15 p_b_30">
            <div class="table-responsive">
                <table class="table_1 table table-striped">
                    <thead>
                        <tr>
                            <th><strong>S No. </strong></th>
                            <th><strong>Join Date</strong></th>
                            <th><strong>User ID </strong></th>
                            <th><strong>Name</strong></th>
                            <th><strong>Business Volume</strong></th>
                            <th><strong>Mobile</strong></th>
                            <th><strong>Sponsor Id</strong></th>
                            <th><strong>Status</strong></th>
                        </tr>
                    </thead> 
                    <tbody>
                        <?php
                        $userdetils = \App\User::whereIn('id', $list)->get();
                        $j = 1;
                        ?>
                        @foreach($userdetils as $user)
                        <tr>
                            <td>{{$j}}</td>
                            <td>{{date('d-m-Y',strtotime($user->created_at))}}</td>
                            <td>{{$user->username}}</td>
                            <td>{{$user->name}} {{$user->last_name}}</td>
                            <td>{{\App\RoiIncome::BusinessVolume($user->id)}}</td>
                            <td>{{$user->mobile}}</td>
                            <td>{{$user->getsponsorid?$user->getsponsorid->username:$user->sponser}}</td>
                            <td>{{$user->active == 0?'Inactive':'Active'}}</td>
                        </tr>
                        <?php $j++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <hr>
        @if ($i== 25) @break; @endif
        <?php $i++; ?>
        @endif
        @endforeach
    </div>
</div>
<!-- /.content -->    
@endsection
@section('script')
<script>
    $(document).ready(function () {
        $('.table_1').DataTable();
    });
</script>
@stop
