@extends('layouts.user')

@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-white-800">User KYC Request</h1>
</div>
@if($user)
<h3>
    {{$user->username}} / {{$user->name}}
</h3>
<a href="{{asset('usermanage')}}" class="pull-right">Back To List</a>
@endif
<div class="row">
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table table-striped table-bordered" id="ctable">
                <thead>
                    <tr class="seprator">
                        <th>Sr No </th>
                        <th>User Id</th>
                        <th>Uploaded date </th>
                        <th>Document type </th>
                        <th>View Document </th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    @foreach($kycs as $kyc)
                    <tr>
                        <td> {{$i}} </td>
                        <td> {{$kyc->getUser?$kyc->getUser->username:''}} </td>
                        <td> {{date('d M Y',strtotime($kyc->created_at))}}</td>
                        <td> {{$kyc->type}} </td>
                        <td title="View Document" class="pointer">
                            <a href="" data-toggle="modal" data-target="#exampleModal{{$kyc->id}}">
                                <i class="fa fa-eye" aria-hidden="true" ></i>
                            </a>
                            <div class="modal fade" id="exampleModal{{$kyc->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <img src="{{asset('kyc_doc/'.$kyc->file)}}" style="max-width:400px;"/>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td> 
                            @if($kyc->status == 0)
                            <span class="text-warning">Pending</span>
                            @elseif($kyc->status == 1)
                            <span class="text-success">Success</span>
                            @else
                            <span class="text-danger">Rejected</span>
                            @endif
                        </td>
                        <td>
                            @if($kyc->status == 1)
                            <!--<a href="{{asset('kyc/removedata/'.$kyc->id)}}" class="btn btn-success btn-sm">Delete</a>-->
                            @else
                            <a href="{{asset('kyc/approved/'.$kyc->id)}}" class="btn btn-success btn-sm">Approved</a>
                            <a href="{{asset('kyc/reject/'.$kyc->id)}}" class="btn btn-sm btn-danger">Reject</a>
                            @endif
                        </td>
                    </tr>
                    <?php $i++; ?>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>  
</div>
@endsection
@section('script')
<script>
    $("#ctable").DataTable();
</script>
@stop