@extends('layouts.user')

@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">ID Card</h1> 
</div>

<div class="row">
    <div class="col-md-12">
        <div id="html-content-holder" style="position:relative;background-image: url('<?= asset('images/id_card.jpeg') ?>');width:500px;height:310px;background-size: cover;background-repeat: no-repeat, repeat;">
            <span style="position: absolute;top: 141px;left: 338px;color: #fff;">{{$user->username}}</span>
            <span style="position: absolute;top: 167px;left: 338px;color: #fff;">{{$user->name}}</span>
            <span style="position: absolute;top: 194px;left: 338px;color: #fff;">{{date('d/m/Y',strtotime($user->created_at))}}</span>
            <span style="position: absolute;top: 223px;left: 338px;color: #fff;">{{$user->boold_group}}</span>
            <span style="position: absolute;top: 252px;left: 338px;color: #fff;">{{$user->mobile}}</span>
        </div>
        <br>
        <br>
        <button type="button" class="btn btn-success" id="btnConvert">Download card</button>
        <br>
        <br>
        <div id="previewImg" style="display:none;"></div>
    </div>
</div>
@endsection
@section('script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js" type="text/javascript"></script> 
<script>
$("#btnConvert").on('click', function () {
    html2canvas(document.getElementById("html-content-holder")).then(function (canvas) {
        var anchorTag = document.createElement("a");
        document.body.appendChild(anchorTag);
        document.getElementById("previewImg").appendChild(canvas);
        anchorTag.download = "IDCard.jpg";
        anchorTag.href = canvas.toDataURL();
        anchorTag.target = '_blank';
        anchorTag.click();
    });
});
</script>
@endsection