@extends('layouts.user')

@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Dashboard</h1> 
    @if(\Auth::user()->active == 0)
    <span class="badge badge-danger" style="font-size:2vw;">Member Id / Name: {{\Auth::user()->username}} / {{\Auth::user()->name}} | ID Status : InActive</span>
    @else
    <span class="badge badge-success" style="font-size:2vw;">Member Id / Name : {{\Auth::user()->username}} / {{\Auth::user()->name}} | ID Status : Active</span>
    @endif
</div>
<div class="row justify-content-start align-items-center">
    <div class="col-md-12 mb-4">
        <form class="text-dark form-inline">
            <label><strong>Referral Links :- </strong></label>
            <div style="cursor:pointer;width: 80%;margin-left:10px;">
                <input type="text" style="display:none;" value="{{asset('register?reffer='.\Auth::user()->username)}}" id="copy_1">
                {{asset('register?reffer='.\Auth::user()->username)}}
                <button class="btn btn-sm btn-info" type="button" onclick="copyToClipboard('copy_1')" >Copy Link <i class="fas fa-copy"></i></button>
            </div>
        </form>

    </div>
</div>
<!-- Content Row -->
<div class="row">
    <!-- Area Chart -->
    <div class="col-md-12">
        <div class="card shadow mb-4">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">My Overview</h6>
            </div>
            <!-- Card Body -->
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card shadow border-start-primary py-2">
                            <div class="card-body">
                                <div class="text-uppercase text-danger fw-bold text-xs mb-1">
                                    <span style="font-size: 18px;">Total Members</span>
                                </div>
                                <div class="row align-items-center no-gutters">
                                    <div class="col"><span><strong>{{$total_team}}</strong></span></div>
                                    <div class="col-auto"><i class="fas fa-users fa-2x text-gray-300"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card shadow border-start-success py-2">
                            <div class="card-body">
                                <div class="text-uppercase text-success fw-bold text-xs mb-1">
                                    <span style="font-size: 18px;">Total Active Members</span>
                                </div>
                                <div class="row align-items-center no-gutters">
                                    <div class="col"><span><strong>{{$total_active_team}}</strong></span></div>
                                    <div class="col-auto"><i class="fas fa-users fa-2x text-gray-300"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card shadow border-start-success py-2">
                            <div class="card-body">
                                <div class="text-uppercase text-success fw-bold text-xs mb-1">
                                    <span style="font-size: 18px;">My Total Investment</span>
                                </div>
                                <div class="row align-items-center no-gutters">
                                    <div class="col"><span><strong>{{App\WalletRequest::amountFormat($my_currentinvestment)}}</strong></span></div>
                                    <div class="col-auto"><i class="fas fa-money-bill-alt fa-2x text-gray-300"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-4">
                        <div class="card shadow border-start-primary py-2">
                            <div class="card-body">
                                <div class="text-uppercase text-info fw-bold text-xs mb-1">
                                    <span style="font-size: 18px;">Wallet</span>
                                </div>
                                <div class="row align-items-center no-gutters">
                                    <div class="col"><span><strong>{{App\WalletRequest::amountFormat(App\Wallet::getWalletblance(\Auth::user()->id))}}</strong></span></div>
                                    <div class="col-auto"><i class="fas fa-wallet fa-2x text-gray-300"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card shadow border-start-success py-2">
                            <div class="card-body">
                                <div class="text-uppercase text-warning fw-bold text-xs mb-1">
                                    <span style="font-size: 18px;">Cash Wallet</span>
                                </div>
                                <div class="row align-items-center no-gutters">
                                    <div class="col"><span><strong>{{App\WalletRequest::amountFormat(App\CashWallet::getWalletblance(\Auth::user()->id))}}</strong></span></div>
                                    <div class="col-auto"><i class="fas fa-wallet fa-2x text-gray-300"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <!-- Area Chart -->
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-danger">
                <h6 class="m-0 font-weight-bold text-white">Income Status</h6>
            </div>
            <!-- Card Body -->
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table">
                            <tr>
                                <th>Income Bonus</th>
                                <th>Amount</th>
                            </tr>
                            <tr>
                                <td>ROI Income</td><td>{{App\WalletRequest::amountFormat($roi_income)}}</td>
                            </tr>
                            <tr>
                                <td>Level Income</td><td>{{App\WalletRequest::amountFormat($refer_roi)}}</td>
                            </tr>
                            <tr>
                                <td>Booster Income</td><td>{{App\WalletRequest::amountFormat($booster_income)}}</td>
                            </tr>
                            <tr>
                                <td>Awards & Rewards</td><td>0</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card shadow mb-4">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-info">
                <h6 class="m-0 font-weight-bold text-white">Other Status</h6>
            </div>
            <!-- Card Body -->
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table">
                            <tr>
                                <td>Direct Team</td><td>{{$direct_team}}</td>
                            </tr>
                            <tr>
                                <td>Level Team</td><td>{{$total_team}}</td>
                            </tr>
                            <tr>
                                <td>Team Business</td><td>{{App\WalletRequest::amountFormat($Team_Business)}}</td>
                            </tr>
                            <tr>
                                <td>Direct Business</td><td>{{App\WalletRequest::amountFormat($Direct_Business)}}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    function copyToClipboard(element) {
        var copyText = document.getElementById(element);
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(copyText.value);
    }

    $(document).on('click', '.changeradiooption', function () {
        $.ajax({
            url: "{{ URL::asset('usermanage/changeposition') }}",
            data: {'set_position': $(this).val()},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                window.location.reload();
            },
            cache: false,
        });
    });
</script>
@endsection