@extends('layouts.user')

@section('content')
<style>
    .card {
        background-color:#F15B41;
        border: none;
    }
    .card-title a{
        color: #000;
        font-size: 20px;
    }
</style>
<div class="row">
    <div class="col-md-6">
        <div class="d-flex align-items-center mb-4">
            <img src="https://api.dicebear.com/7.x/bottts-neutral/svg?seed=User" style="margin-right:15px;" class="rounded-circle me-3" width="60" height="60" />
            <div>
                <h5 class="mb-0">{{\Auth::user()->name}}</h5>
                <small class="text-muted">UID: {{\Auth::user()->username}} · Level: Silver Star</small>
            </div>
        </div>
    </div>
    <div class="col-md-6 text-right">
        <span style="border:3px solid #F15B41;padding: 7px;">Wallet : {{App\WalletRequest::amountFormat(\App\Wallet::getWalletblance(\Auth::user()->id))}} </span> 
    </div>
</div>

<div class="d-flex justify-content-between align-items-center">
    <h2>Dashboard</h2>
    <form class="text-dark form-inline">
        <a class="btn btn-warning" href="{{asset('usermanage/profile')}}"><i class="bi bi-person-circle"></i> Profile</a>
        <div style="cursor:pointer;margin-left:10px;">
            <input type="text" style="display:none;" value="{{asset('register?reffer='.\Auth::user()->username)}}" id="copy_1">
            <button class="btn btn-warning" type="button" onclick="copyToClipboard('copy_1')" >Copy Link <i class="fas fa-copy"></i></button>
            <a style="padding:0 10px;" class="btn btn-warning" href="https://web.whatsapp.com/send?text={{asset('register?reffer='.\Auth::user()->username)}}" data-action="share/whatsapp/share"><i style="font-size:30px;color:green;" class="fab fa-whatsapp-square"></i></a>
        </div>
    </form>
</div>
@if(\Auth::user()->block == 1)
<div class="alert">
    <div class="alert alert-danger">
        Congratulations. You have successfully earned 1.5 times your income! Please upgrade your ID immediately. If not upgraded, it will affect your earnings. Thank you. <a href="{{asset('topuppackages/memberactivation')}}">Upgrade</a>
    </div>
</div>
@endif
<div class="row mt-4">
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('topuppackages/mypackages')}}">My Investment</a></h6>
                <p class="card-text fs-4">RS.{{App\WalletRequest::amountFormat($my_currentinvestment)}}</p>
                <p class="card-text fs-4">${{$my_currentinvestment/100}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title">Team Investment</h6>
                <p class="card-text fs-4">RS.{{App\WalletRequest::amountFormat($Team_Business)}}</p>
                <p class="card-text fs-4">${{$Team_Business/100}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/mydirects')}}">My Directs</a></h6>
                <p class="card-text fs-4">{{$direct_team}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('wallet/withdrawalreport')}}">Payout Received</a></h6>
                <?php $recive = App\Wallet::where('user_id', \Auth::user()->id)->where('flag', 1)->sum('total_amount'); ?>
                <p class="card-text fs-4">Rs.{{$recive}}</p>
                <p class="card-text fs-4">${{$recive/100}}</p>
            </div>
        </div>
    </div>
</div>
<h2>My ROI</h2>
<div class="row mt-4">
    <div class="col-md-4 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/roiincome')}}">Daily ROI</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($today_roi_income)}}</p>
                <p class="card-text fs-4">${{$today_roi_income/100}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/roiincome')}}">Total ROI</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($roi_income)}}</p>
                <p class="card-text fs-4">${{$roi_income/100}}</p>
            </div>
        </div>
    </div>
</div>
<h2>My Incentives</h2>
<div class="row mt-4">
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/directincome')}}">Direct Referral</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($direct_income)}}</p>
                <p class="card-text fs-4">${{$direct_income/100}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title"><a href="{{asset('reports/referralincome/'.\Auth::user()->id)}}">Daily Level On ROI</a></h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat($refer_roi)}}</p>
                <p class="card-text fs-4">${{$refer_roi/100}}</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title">Cumulative Level of ROI</h6>
                <p class="card-text fs-4">Rs.0</p>
                <p class="card-text fs-4">$0</p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-4">
        <div class="card text-white">
            <div class="card-body">
                <h6 class="card-title">Total Incentive</h6>
                <p class="card-text fs-4">Rs.{{App\WalletRequest::amountFormat(\App\Wallet::getWalletblance(\Auth::user()->id))}}</p>
                <p class="card-text fs-4">${{\App\Wallet::getWalletblance(\Auth::user()->id)/100}}</p>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    function copyToClipboard(element) {
        var copyText = document.getElementById(element);
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(copyText.value);
    }
    // Pie Chart Example
    $(document).on('click', '.changeradiooption', function () {
        $.ajax({
            url: "{{ URL::asset('usermanage/changeposition') }}",
            data: {'set_position': $(this).val()},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                window.location.reload();
            },
            cache: false,
        });
    });
</script>
@endsection