@extends('layouts.user')
@section('css')

@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Fund Request Report</h1>
</div>
<div class="card shadow">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table" id="Datatable">
                <thead>
                    <tr class="seprator">
                        <th>Sr No </th>
                        <th>Fund Amount</th>
                        <th>Transaction Id</th>
                        <th>Mode</th>
                        <th>Payment Proof</th>
                        <th>Note</th>
                        <th>Request Date </th>
                        <th>Status</th>
                        <th>Reason</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    @foreach($allrecords as $package)
                    <tr>
                        <td> {{$i}} </td>
                        <td>{{App\WalletRequest::amountFormat($package->amount)}}</td>
                        <td>
                            {{$package->transaction_id}}
                        </td>
                        <td>
                            {{$package->mode}}
                        </td>
                        <td title="View Document" class="pointer">
                            @if($package->mode != 'fund')
                            @if($package->payment_proof)
                            <a href="{{asset('payment_proof/'.$package->payment_proof)}}" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                            @else
                            <a href="{{asset('topuppackages/uploadproof/'.$package->id)}}">Upload Proof</a>
                            @endif
                            @endif
                        </td>
                        <td>
                            {{$package->note}}
                        </td>
                        <td> {{date('d-m-Y H:i',strtotime($package->created_at))}}</td>
                        <td> 
                            @if($package->status == 0)
                            <span class="text-warning">Pending</span>
                            @elseif($package->status == 1)
                            <span class="text-success">Success</span>
                            Approved / {{date('d-m-Y H:i',strtotime($package->approve_date))}}
                            @else
                            <span class="text-danger">Rejected</span>
                            @endif
                        </td>
                        <td>{{$package->reason}}</td>
                        <td>
                            @if($package->status != 1)
                            <a class="btn btn-danger" href="{{asset('topuppackages/removetopuprequest/'.$package->id)}}">Delete</a>
                            @endif
                        </td>
                    </tr>
                    <?php $i++; ?>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>                                                                                             
@endsection

@section('script')
<script>
    $('#Datatable').DataTable();

    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
@endsection
