<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
        <title>MalaysianTrade</title>
        <link rel="stylesheet" href="{{asset('css/sb-admin-2.min.css')}}">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
        <style>
            .form-control-user{
                border-radius: 8px !important;
            }
            .error {
                color:red;
                font-size:15px;
                width:100%;
            }
            body {
                background-image: url('<?= asset('images/background.jpg') ?>') !important;
                background-color: #cccccc;
            }
            h4{
                color:#ffcc00 !important;
            }
        </style>
    </head>
    <body class="bg-gradient-primary" style="background: var(--bs-gray-100);">
        <div class="container">
            <div class="card shadow-lg o-hidden border-0 my-5">
                <div class="card-body p-0">
                    <div class="row justify-content-center">
                        <div class="col-lg-7">
                            <div class="p-5" style="border-radius: 36px;">
                                <div class="text-center"><img src="{{asset('images/logo.png')}}" style="height:120px;">
                                </div>
                                @if(\Session::get('success'))
                                <div class="alert alert-success alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                    <h5><i class="icon fas fa-check"></i> Success!</h5>
                                    {{\Session::get('success')}}
                                </div>
                                @endif
                                
                                Dear {{$user->name}}
                                <br>
                                <br>
                                Congratulations on joining MalaysianTrade
                                <br>
                                <br>
                                We are in the prelaunch phase.
                                <br><br>
                                Your Username : {{$user->username}}<br>
                                Your password : {{$user->password_text}}
                                <br><br>
                                Join your friends and relatives and make them wealthy with MalaysianTrade products and services.
                                <br><br>
                                Use the following link to refer new members.
                                <br><br>
                                {{asset('register?reffer='.$user->username)}}
                                <br><br>
                                Thank you <br>
                                Team MalaysianTrade
                                <br><br>
                                <div class="text-center">
                                    <a class="small" href="{{ asset('login') }}" style="font-size: 23px;">
                                        Login Your Account
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>