@extends('layouts.user')
@section('css')
<!-- Theme style -->
<!--<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/style.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/const.css') }}">
<link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/poppin.css') }}">-->
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-white-800">ROI Income : {{$user->username}}</h1>
    <a href="{{asset('reports/roiincome')}}" class="pull-right">Back To List</a>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <?php $i = 1; ?>
                    @foreach($packages as $package)
                    <li class="nav-item">
                        <a class="nav-link <?= $i == 1 ? 'active' : '' ?>" id="home-tab" data-toggle="tab" href="#package_{{$package->id}}" role="tab" aria-controls="home"
                           aria-selected="true">{{$package->package_name}}<br> {{date('d-m-Y H:i',strtotime($package->created_at))}}</a>
                    </li>
                    <?php $i++; ?>
                    @endforeach
                </ul>
                <div class="tab-content" id="myTabContent">
                    <?php $alp = 1; ?>
                    @foreach($packages as $package)
                    <div class="tab-pane fade show <?= $alp == 1 ? 'active' : '' ?>" id="package_{{$package->id}}" role="tabpanel" aria-labelledby="home-tab">
                        <div class="row  mt-3">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped ctable">
                                        <thead>
                                            <tr>
                                                <th><strong>Day</strong></th>
                                                <th><strong>Date</strong></th>
                                                <th><strong>Amount</strong></th>
                                                <th><strong>TDS/Admin Charges</strong></th>
                                                <th><strong>Net Amount</strong></th>
                                                <th><strong>Added Wallet</strong></th>
                                            </tr>
                                        </thead> 
                                        <tbody>
                                            <?php
                                            $monthly = \App\RoiIncome::where('user_id', $user->id)
                                                            ->where('wallet_request_id', $package->id)->where('status', 1)
                                                            ->select('id', 'user_id', 'status', 'wallet_request_id', 'days', 'date', 'amount', 'net_amount', 'charges')->get();
                                            ?>
                                            <?php $j = 1; ?>
                                            @foreach($monthly as $roi)
                                            <tr>
                                                <td>{{$roi->days}}</td>
                                                <td>{{$roi->date}}</td>
                                                <td>{{\App\WalletRequest::amountFormat($roi->amount)}}</td>
                                                <td>{{\App\WalletRequest::amountFormat($roi->charges)}}</td>
                                                <td>{{\App\WalletRequest::amountFormat($roi->net_amount)}}</td>
                                                <td>
                                                    {{$roi->status == 1?'Added':'No'}}
                                                </td>
                                            </tr>
                                            <?php $j++; ?>
                                            @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $alp++; ?>
                    @endforeach
                </div>                
            </div>
        </div>
    </div>
</div>
<div style="clear:both;"></div>
<!-- /.content -->    
@endsection


@section('script')
<script>
    $(".ctable").DataTable();
</script>
@stop
