<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
        <title>MalaysianTrade - Register</title>
        <link rel="stylesheet" href="{{asset('css/sb-admin-2.min.css')}}">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
        <style>
            .form-control-user{
                border-radius: 8px !important;
            }
            .error {
                color:red;
                font-size:15px;
                width:100%;
            }
            body {
                background-color: #000 !important;
            }
            h4{
                color:#ffcc00 !important;
            }
        </style>
    </head>
    <body class="bg-gradient-primary" style="background: var(--bs-gray-100);">
        <div class="container">
            <div class="card shadow-lg o-hidden border-0 my-5">
                <div class="card-body p-0">
                    <div class="row justify-content-center">
                        <div class="col-lg-7">
                            <div class="p-5" style="border-radius: 36px;">
                                <div class="text-center"><img src="{{asset('images/logo.png')}}" style="height:120px;">
                                </div>
                                @if(\Session::get('success'))
                                <div class="alert alert-success alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                    <h5><i class="icon fas fa-check"></i> Success!</h5>
                                    {{\Session::get('success')}}
                                </div>
                                @endif

                                Dear {{$user->name}}
                                <br>
                                <br>
                                Congratulations on joining MalaysianTrade
                                <br>
                                <br>
                                We are in the prelaunch phase.
                                <br><br>
                                Your Username : {{$user->username}}<br>
                                Your Password : {{$user->password_text}}<br>
                                Your Transaction Password : {{$user->tpass}}
                                <br><br>
                                Join your friends and relatives and make them wealthy with MalaysianTrade products and services.
                                <br><br>
                                Use the following link to refer new members.
                                <br><br>
                                {{asset('register?reffer='.$user->username)}}
                                <br><br>
                                Thank you <br>
                                Team MalaysianTrade
                                <br><br>
                                <div class="text-center">
                                    <a class="small" href="{{ asset('login') }}" style="font-size: 23px;">
                                        Login Your Account
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Bootstrap core JavaScript-->
        <script src="{{asset('plugins/jquery/jquery.min.js')}}"></script>
        <script src="{{asset('plugins/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
        <!-- Core plugin JavaScript-->
        <script src="{{asset('plugins/jquery-easing/jquery.easing.min.js')}}"></script>
        <!-- Custom scripts for all pages-->
        <script src="{{asset('js/sb-admin-2.min.js')}}"></script>
        <script src="{{asset('plugins/bootstrap/js/bootstrap.min.js')}}"></script>
        <script src="{{asset('plugins/jquery-validation/jquery.validate.min.js')}}"></script>
        <script src="{{asset('plugins/jquery-validation/additional-methods.min.js')}}"></script>

        <script>
$(document).ready(function () {

    $(document).on('blur', '#sponsor_change', function () {
        if ($(this).val() != '')
        {
            var sponsor = $("#sponsor_change").val().trim();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                url: "{{ asset('frontdata/fetchsponsor') }}",
                method: "POST",
                data: {sponsor: sponsor, _token: _token},
                success: function (response)
                {
                    if (response) {
                        $("#sponsor_response").html(response);
                    } else {
                        $("#sponsor_response").html('Invalid Sponsor ID');
                    }
                }
            })
        }
    });
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $(function () {
        $('#registerform').validate({
            rules: {
                username: {
                    required: true,
                    alphanumeric: true
                },
                mobile: {
                    minlength: 10,
                    maxlength: 10

                },
                password: {
                    minlength: 6
                },
                password_confirm: {
                    minlength: 6,
                    equalTo: "#samepassword"
                }
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                error.insertAfter(element);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


});
        </script>
    </body>
</html>