@extends('layouts.user')
@section('css')
<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
</style>
@stop
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Fund Requests</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home"
                   aria-selected="true">Pending Request</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile"
                   aria-selected="false">Approved Request</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact"
                   aria-selected="false">Rejected Request</a>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                <div class="row">
                    <div class="col-md-12">
                        <br>
                        <br>
                        <div class="table-responsive">
                            <table id="Datatable" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="seprator">
                                        <th>Username</th>
                                        <th>Name</th>
                                        <th>Request Date </th>
                                        <th>Amount</th>
                                        <th>Mode</th>
                                        <th>Transaction Id</th>
                                        <th>Payment Proof</th>
                                        <th>Note</th>
                                        <th>Status</th>
                                        <th>Reason</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    @foreach($panding as $row)
                                    @if($row->getUser)
                                    <tr>
                                        <td> {{$row->getUser->username}}</td>
                                        <td> {{$row->getUser->name}}</td>
                                        <td> {{date('d-m-Y H:i',strtotime($row->created_at))}}</td>
                                        <td>
                                            {{App\WalletRequest::amountFormat($row->amount)}}
                                        </td>
                                        <td>
                                            {{$row->mode == 'Wallet'?'Cash Wallet':'Bank Transfer'}}
                                        </td>
                                        <td>
                                            {{$row->transaction_id}}
                                        </td>
                                        <td title="View Document" class="pointer">
                                            @if($row->payment_proof)
                                            <a href="{{asset('payment_proof/'.$row->payment_proof)}}" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                                            @endif
                                        </td>
                                        <td>{{$row->note}}</td>
                                        <td> 
                                            @if($row->status == 0)
                                            <span class="text-warning">Pending</span>
                                            @elseif($row->status == 1)
                                            <span class="text-success">Success</span>
                                            @else
                                            <span class="text-danger">Rejected</span>
                                            @endif
                                        </td>

                                        <td>{{$row->reason}}</td>
                                        <td>
                                            @if($row->status != 1)
                                            <button class="btn btn-sm btn-success approved_btn" type="button" id="{{$row->id}}">Approved</button>
                                            <button class="btn btn-sm btn-danger delete_btn" type="button" id="{{$row->id}}">Reject</button>
                                            @endif
                                        </td>
                                    </tr>
                                    <?php $i++; ?>
                                    @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                <div class="row">
                    <div class="col-md-12">
                        <br>
                        <br>
                        <div class="table-responsive">
                            <table id="Datatable_2" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="seprator">
                                        <th>Username</th>
                                        <th>Name</th>
                                        <th>Request Date </th>
                                        <th>Price</th>
                                        <th>Transaction Id</th>
                                        <th>Payment Proof</th>
                                        <th>Note</th>
                                        <th>Status</th>
                                        <th>Reason</th>
                                        <th>Approve Date/Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    @foreach($approved as $row)
                                    @if($row->getUser)
                                    <tr>
                                        <td>
                                            {{$row->getUser->username}}
                                            <!--<a class="" href="{{asset('topuppackages/updatepackage/'.$row->id)}}">Edit</a>-->
                                        </td>
                                        <td> {{$row->getUser->name}}</td>
                                        <td> {{date('d-m-Y H:i',strtotime($row->created_at))}}</td>
                                        <td>{{App\WalletRequest::amountFormat($row->amount)}}</td>
                                        <td>
                                            {{$row->transaction_id}}
                                        </td>
                                        <td title="View Document" class="pointer">
                                            @if($row->payment_proof)
                                            <a href="{{asset('payment_proof/'.$row->payment_proof)}}" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                                            @endif
                                        </td>
                                        <td>{{$row->note}}</td>
                                        <td> 
                                            @if($row->status == 0)
                                            <span class="text-warning">Pending</span>
                                            @elseif($row->status == 1)
                                            <span class="text-success">Success</span>
                                            @else
                                            <span class="text-danger">Rejected</span>
                                            @endif
                                        </td>
                                        <td>{{$row->reason}}</td>
                                        <td>
                                            {{$row->approve_date}}
                                        </td>
                                    </tr>
                                    <?php $i++; ?>
                                    @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                <br>
                <br>
                <div class="table-responsive">
                    <table id="Datatable_3" class="table table-bordered table-striped">
                        <thead>
                            <tr class="seprator">
                                <th>Username</th>
                                <th>Name</th>
                                <th>Request Date </th>
                                <th>Amount</th>
                                <th>Transaction Id</th>
                                <th>Payment Proof</th>
                                <th>Status</th>
                                <th>Reason</th>
                                <th>Reject Date/Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            @foreach($rejected as $row)
                            @if($row->getUser)
                            <tr>
                                <td> {{$row->getUser->username}}</td>
                                <td> {{$row->getUser->name}}</td>
                                <td> {{date('d-m-Y H:i',strtotime($row->created_at))}}</td>
                                <td>{{App\WalletRequest::amountFormat($row->amount)}}</td>
                                <td>
                                    {{$row->transaction_id}}
                                </td>
                                <td title="View Document" class="pointer">
                                    @if($row->payment_proof)
                                    <a href="{{asset('payment_proof/'.$row->payment_proof)}}" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                                    @endif
                                </td>
                                <td> 
                                    @if($row->status == 0)
                                    <span class="text-warning">Pending</span>
                                    @elseif($row->status == 1)
                                    <span class="text-success">Success</span>
                                    @else
                                    <span class="text-danger">Rejected</span>
                                    @endif
                                </td>

                                <td>{{$row->reason}}</td>
                                <td>
                                    {{$row->approve_date}}
                                </td>
                            </tr>
                            <?php $i++; ?>
                            @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div> 
@endsection

@section('script')
<script>
    var tabledata = $('#Datatable').DataTable();
    var tabledata2 = $('#Datatable_2').DataTable();
    var tabledata3 = $('#Datatable_3').DataTable();

    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Reject Reason",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reject it!',
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value != '') {
                        resolve()
                    } else {
                        resolve('Reason Required...')
                    }
                })
            }
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "{{ URL::asset('topuppackages/rejecteentry') }}",
                    data: {'row_id': $(this).attr('id'), 'reason': result.value},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('change', '.changeroi', function () {
        $.ajax({
            url: "{{ URL::asset('topuppackages/changeroistatus') }}",
            data: {'row_id': $(this).attr('id'), 'value': $(this).val()},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {

            },
            cache: false,
        });
    });
    $(document).on('click', '.approved_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Text",
            icon: 'success',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Approve it!',
        }).then((result) => {
            $.ajax({
                url: "{{ URL::asset('topuppackages/approveentry') }}",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        });
    });

</script>
@endsection
