@extends('layouts.user')
@section('css')
<link rel="stylesheet" href="{{asset('plugins/dist/themes/default/style.min.css')}}">
<style>
    h1 { font-size:1.8em; }
    .demo { overflow:auto; border:1px solid silver; min-height:100px; }
</style>
@stop

@section('content')
<div class="clearfix"></div>
<div class="row">
    @if(Session::get('error'))
    <div class="col-md-6">
        <div class="alert alert-danger">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
            {{Session::get('error')}}
        </div>
    </div>
    @endif
</div>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0">Level Reports</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <form class="form-inline">
            <label>Enter User ID&nbsp;</label>
            <input type="text"  name="usertree" value="{{request('usertree')}}" class="form-control" required/>
            &nbsp;&nbsp;<button type="submit" class="btn btn-success">Get Data</button>
        </form>
    </div>
</div>
<hr>
<div class="row-fluid">
    <div class="col-md-12 col-sm-12" style="padding:0px;margin-top:0px;">
        <div id="html" class="demo" style="border:none;">
            <ul>
                <?php
                $name = $user_inner->name . ' ' . $user_inner->last_name;
                $m_id = $user_inner->username;
                $getsponsor = $user_inner->getsponsorid ? $user_inner->getsponsorid->name . ' ' . $user_inner->getsponsorid->last_name : '';
                $placeunder = $user_inner->placed_under;
                $title = 'Member Id : ' . $m_id;
                $title .= '&#13;Member Name : ' . $name;
                $title .= '&#13;Date Of Join : ' . date('d-M-Y', strtotime($user_inner->created_at));
                ?>
                <li data-jstree='{ "opened" : true }'>
                    {{$user_inner->username}} - {{$user_inner->name}}

                    {!!$user_inner->getTreeList($user_inner->id,$count=1)!!}
                </li>
            </ul>
        </div>
    </div>
</div>
@stop
@section('script')
<script src="{{asset('plugins/dist/jstree.min.js')}}"></script>
<script>
$(document).ready(function () {
    $('#html').jstree();
});
</script>
@stop