@extends('layouts.user')

@section('css')
<style>
    .table .btn{
        margin:3px;
    }
</style>
@endsection
@section('content')
<div class="row">
    <div class="col-lg-12 col-12">
        <form class="form-inline" id="formwisedata">
            <label class="text-danger">Select Filter </label>  
            <select class="form-control" id="formwisedatachange" name="option">
                <option value="All">All</option>
                <option value="1">Active</option>
                <option value="0">InActive</option>
                <option value="suspend">Suspend</option>
            </select>
        </form>
    </div>
</div>
<br>
<br>
<div class="row">
    <div class="col-lg-12 col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="Datatable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Mobile</th>
                                <th>Password</th>
                                <th>Invseted Amount</th>
                                <th>Referred By</th>
                                <th>Join Date</th>
                                <th>Status</th>
                                <th style="width:100px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    /*
     $(function () {
     $("#example1").DataTable({
     "responsive": true,
     "lengthChange": false,
     "autoWidth": false,
     "buttons": ["excel", "pdf"]
     }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
     });*/

    $('#Datatable').DataTable({
        processing: true,
        serverSide: true,
        "order": [0, 'desc'],
        destroy: true,
        ajax: '{{asset("usermanage/data")}}?' + $(document).find('#formwisedata').serialize(),
        columns: [
            {data: 'username', name: 'username', orderable: true},
            {data: 'name', name: 'name', orderable: true},
            {data: 'mobile', name: 'mobile', orderable: true},
            {data: 'password_text', name: 'password_text', orderable: false},
            {data: 'invseted', name: 'invseted', orderable: true, searchable: false},
            {data: 'sponser', name: 'sponser', orderable: false},
            {data: 'created_at', name: 'created_at', orderable: true},
            {data: 'active', name: 'active', orderable: false},
            {data: 'action', name: 'action', orderable: false, searchable: false}
        ]
    });


    $(document).on('change', '#formwisedatachange', function () {
        $('#Datatable').DataTable({
            processing: true,
            serverSide: true,
            destroy: true,
            "order": [0, 'desc'],
            ajax: '{{asset("usermanage/data")}}?' + $(document).find('#formwisedata').serialize(),
            columns: [
                {data: 'username', name: 'username', orderable: true},
                {data: 'name', name: 'name', orderable: true},
                {data: 'mobile', name: 'mobile', orderable: true},
                {data: 'password_text', name: 'password_text', orderable: false},
                {data: 'invseted', name: 'invseted', orderable: true, searchable: false},
                {data: 'sponser', name: 'sponser', orderable: false},
                {data: 'created_at', name: 'created_at', orderable: true},
                {data: 'active', name: 'active', orderable: false},
                {data: 'action', name: 'action', orderable: false, searchable: false}
            ]
        });

    });
    $(document).on('click', '.setinactiveuser', function () {
        Swal.fire({
            title: 'Are you sure Inactive this uer?',
            text: "",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Inactive it!',
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "{{ URL::asset('usermanage/inactiveuser') }}",
                    data: {'row_id': $(this).attr('id')},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });
    $(document).on('click', '.setreactiveinactiveuser', function () {
        Swal.fire({
            title: 'Are you sure un suspend and Reactive this uer?',
            text: "",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reactive it!',
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "{{ URL::asset('usermanage/reinactiveuser') }}",
                    data: {'row_id': $(this).attr('id')},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });
</script>
@endsection

