@extends('layouts.user')

@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">My Profile</h1> <a href="{{asset('usermanage')}}" class="pull-right">Back To List</a>
</div>
<div class="row mb-3">
    <div class="col-lg-4">
        <div class="card mb-3">
            <div class="card-body text-center shadow">
                <form action="{{asset('usermanage/changeprofileimage/'.$user->id)}}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    @if($user->profile_image)
                    <img class="rounded-circle img-thumbnail mb-3 mt-4" src="{{asset('profile_image/'.$user->profile_image)}}" style="height:170px;">
                    @else
                    <img class="rounded-circle img-thumbnail mb-3 mt-4" src="{{asset('images/blank_user.png')}}" style="height:170px;">
                    @endif
                    <div class="mb-3">
                        <input type="file" name="profile_image" id="profile_image" style="opacity:0;width:0" />
                        <button id="btn-upload" class="btn btn-primary btn-sm" type="button">Change Photo</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="row">
            <div class="col">
                <div class="card shadow mb-3">
                    <div class="card-header py-3">
                        <p class="text-primary m-0 fw-bold">User Settings</p>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ asset('usermanage/updateuser/'.$user->id) }}" class="user" id="registerform">
                            @csrf
                            <div class="row">
                                <div class="col">
                                    <div class="mb-3">
                                        <label class="form-label" for="username"><strong>Username</strong></label>
                                        <input class="form-control" type="text" id="username" placeholder="" value="{{$user->username}}" name="username" required>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="mb-3">
                                        <label class="form-label" for="email"><strong>Email Address</strong></label>
                                        <input class="form-control" type="email" id="email" value="{{$user->email}}" name="email" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="first_name"><strong>First Name</strong></label>
                                            <input class="form-control form-control-user" type="text" value="{{$user->name}}" name="name" required />
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="first_name"><strong>Last Name</strong></label>
                                            <input class="form-control form-control-user" type="text" value="{{$user->last_name}}" name="last_name" required />
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="email"><strong>Mobile Number</strong></label>
                                            <input class="form-control" type="number" id="email" value="{{$user->mobile}}" name="mobile" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <button class="btn btn-primary btn-sm" type="submit">Save Settings</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card shadow">
                    <div class="card-header py-3">
                        <p class="text-primary m-0 fw-bold">Account Details</p>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ asset('usermanage/updatetoken/'.$user->id) }}" class="user" id="WalletAddressform">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label" for="address"><strong>Wallet Address</strong></label>
                                <input class="form-control" type="text" id="address" value="{{$user->token}}" placeholder="Wallet Address" name="token" required>
                            </div>
                            <div class="mb-3"><button class="btn btn-primary btn-sm" type="submit">Save&nbsp;Settings</button></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {
        $(function () {
            $('#btn-upload').click(function (e) {
                e.preventDefault();
                $('#profile_image').click();
            });
        });
        $(document).on('change', '#profile_image', function () {
            $(this).closest('form').submit();
        });

        $(function () {
            $('#registerform').validate({
                rules: {
                    username: {
                        required: true,
                        alphanumeric: true
                    }
                },
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
        $(function () {
            $('#WalletAddressform').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
@endsection