@extends('layouts.user')
@section('css')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
<style>
    .table .btn{
        margin:3px;
    }
</style>
@endsection
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0">Admin Edit - {{$user->username}}</h1>
    @if(\Auth::user()->role == 1)
    <a href="{{asset('subadmin')}}" class="pull-right">Back To List</a>
    @endif
</div>
<div class="row mb-3">
    <div class="col-lg-4">
        <div class="card mb-3">
            <div class="card-body text-center shadow">
                <form action="{{asset('usermanage/changeprofileimage/'.$user->id)}}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    @if($user->profile_image)
                    <img class="rounded-circle img-thumbnail mb-3 mt-4" src="{{asset('profile_image/'.$user->profile_image)}}" style="height:170px;">
                    @else
                    <img class="rounded-circle img-thumbnail mb-3 mt-4" src="{{asset('images/blank_user.png')}}" style="height:170px;">
                    @endif
                    <div class="mb-3">
                        <input type="file" name="profile_image" id="profile_image" style="opacity:0;width:0" />
                        <button id="btn-upload" class="btn btn-primary btn-sm" type="button">Change Photo</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="row">
            <div class="col">
                <div class="card shadow mb-3">
                    <div class="card-header py-3">
                        <p class="text-primary m-0 fw-bold">User Settings</p>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ asset('subadmin/updateuser/'.$user->id) }}" class="user" id="registerform">
                            @csrf
                            <div class="form-group">
                                <div class="row">
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="username"><strong>Username</strong></label>
                                            <input class="form-control" type="text" disabled id="username" placeholder="" value="{{$user->username}}">
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="first_name"><strong>Full Name</strong></label>
                                            <input class="form-control" type="text" value="{{$user->name}}" name="name" required />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="email"><strong>Email Address</strong></label>
                                            <input class="form-control" type="email" id="email" value="{{$user->email}}" name="email">
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="mb-3">
                                            <label class="form-label" for="email"><strong>Mobile Number</strong></label>
                                            <input class="form-control" type="number" id="email" value="{{$user->mobile}}" name="mobile" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="font-weight-bold control-label">Select Menu For User</label><br>
                                <?php $rs = @unserialize($user->rights)?unserialize($user->rights):array(); ?>
                                <select name="rights[]" class="selectpicker" required multiple>
                                    @foreach($r_array as $kry=>$v)
                                    <option value="{{$kry}}" <?=in_array($kry,$rs)?'selected':'' ?>>{{$v}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3">
                                <button class="btn btn-primary btn-sm" type="submit">Save Settings</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
<script>
$(document).ready(function () {
    $('.selectpicker').selectpicker();
    $(function () {
        $('#btn-upload').click(function (e) {
            e.preventDefault();
            $('#profile_image').click();
        });
    });
    $(document).on('change', '#profile_image', function () {
        $(this).closest('form').submit();
    });

    $(function () {
        $('#registerform').validate({
            rules: {
                username: {
                    required: true,
                    alphanumeric: true
                }
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                error.insertAfter(element);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
    $(function () {
        $('#WalletAddressform').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                error.insertAfter(element);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


    var tabledata = $('#Datatable').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{asset("usermanage/bankdata/".$user->id)}}',
        columns: [
            {data: 'holder_name', name: 'holder_name'},
            {data: 'number', name: 'number'},
            {data: 'bank_name', name: 'bank_name'},
            {data: 'branch_name', name: 'branch_name'},
            {data: 'ifsc_code', name: 'ifsc_code'},
            {data: 'action', name: 'action', orderable: false, searchable: false, width: '100px'}
        ]
    });

    $(document).on('click', '#openaddmodel', function () {
        $('#openaddmodelModal').modal('show');
    });
    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '{{asset("usermanage/savebankdetails/".$user->id)}}',
                    data: {delete_row: 'delete_row', 'row_id': $(this).attr('id')},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        tabledata.draw();
                    },
                    cache: false,
                });
            }
        });
    });
    $(document).on('click', '.update_btn', function () {
        $.ajax({
            url: '{{asset("usermanage/savebankdetails/".$user->id)}}',
            data: {edit_data: 'edit_data', 'row_id': $(this).attr('id')},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                $(document).find("input[name='update_id']").val(data.row.id);
                $(document).find("input[name='payee_name']").val(data.row.holder_name);
                $(document).find("input[name='account_number']").val(data.row.number);
                $(document).find("select[name='bank_name']").val(data.row.bank_name);
                $(document).find("input[name='branch']").val(data.row.branch_name);
                $(document).find("input[name='ifsc']").val(data.row.ifsc_code);
                $('#openaddmodelModal').modal('show');
            },
            cache: false,
        });
    });
    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
});
</script>
@endsection

