@extends('layouts.user')

@section('css')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
<style>
    .table .btn{
        margin:3px;
    }
</style>
@endsection
@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0">Sub Admin Manage</h1>
</div>
<button class="btn btn-success" id="openaddmodel">
    Add New Admin <i class="fas fa-plus"></i>
</button>
<br>
<br>
<div class="row">
    <div class="col-lg-12 col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="Datatable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Username</th>
                                <th>Name</th>
                                <th>Mobile</th>
                                <th>Password</th>
                                <th>Created</th>
                                <th>User Menu Rights</th>
                                <th>Status</th>
                                <th style="width:100px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="openaddmodelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Sub Admin User</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{asset('subadmin/createuser')}}" id="quickForm" method="post" enctype="multipart/form-data">
                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                <input type="hidden" name="update_id" value="" />
                <input type="password" style="display:none;"/>
                <div class="modal-body">
                    <div class="form-group">
                        <label  class="font-weight-bold control-label">Enter Username/Login Name</label>       
                        <input  type="text" class="form-control" autocomplete="off" name="username" required>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold control-label">Enter Full Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold control-label">Enter E-mail</label>
                        <input type="text" class="form-control" name="email" required>
                    </div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label class="font-weight-bold control-label">Enter Password</label>
                                <input type="password" class="form-control" name="password">
                            </div>
                            <div class="col-md-6">
                                <label class="font-weight-bold control-label">Confirm Password</label>
                                <input type="password" class="form-control" name="password_confirmation">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="font-weight-bold control-label">Select Menu For User</label><br>
                        <select name="rights[]" class="selectpicker" required multiple>
                            @foreach($r_array as $kry=>$v)
                            <option value="{{$kry}}">{{$v}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save Data</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
<script>
$('.selectpicker').selectpicker();
/*
 $(function () {
 $("#example1").DataTable({
 "responsive": true,
 "lengthChange": false,
 "autoWidth": false,
 "buttons": ["excel", "pdf"]
 }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
 });*/

$('#Datatable').DataTable({
    processing: true,
    serverSide: true,
    "order": [0, 'desc'],
    destroy: true,
    ajax: '{{asset("subadmin/data")}}?' + $(document).find('#formwisedata').serialize(),
    columns: [
        {data: 'username', name: 'username', orderable: true},
        {data: 'name', name: 'name', orderable: true},
        {data: 'mobile', name: 'mobile', orderable: true},
        {data: 'password_text', name: 'password_text', orderable: false},
        {data: 'created_at', name: 'created_at', orderable: true},
        {data: 'rights', name: 'rights', orderable: false, searchable: false},
        {data: 'active', name: 'active', orderable: false},
        {data: 'action', name: 'action', orderable: false, searchable: false}
    ]
});

$(document).on('click', '.setinactiveuser', function () {
    Swal.fire({
        title: 'Are you sure Inactive this uer?',
        text: "",
        icon: 'error',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#17a2b8',
        confirmButtonText: 'Yes, Inactive it!',
    }).then((result) => {
        if (result.value) {
            $.ajax({
                url: "{{ URL::asset('subadmin/inactiveuser') }}",
                data: {'row_id': $(this).attr('id')},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        }
    });
});
$(document).on('click', '.setreactiveinactiveuser', function () {
    Swal.fire({
        title: 'Are you sure un suspend and Reactive this uer?',
        text: "",
        icon: 'error',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#17a2b8',
        confirmButtonText: 'Yes, Reactive it!',
    }).then((result) => {
        if (result.value) {
            $.ajax({
                url: "{{ URL::asset('subadmin/reinactiveuser') }}",
                data: {'row_id': $(this).attr('id')},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        }
    });
});

$(document).on('click', '#openaddmodel', function () {

    $('#quickForm').find('.form-group input').val('');
    $('#openaddmodelModal').modal('show');
});
</script>
@endsection

