@extends('layouts.user')
@section('css')

@stop
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card shadow-lg o-hidden border-0">
            <div class="card-body text-center">
                <br>
                <br>
                {{$text}}
                <br>
                <br>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
    $(document).on('blur', '#sponsor_change', function () {
        if ($(this).val() != '')
        {
            var sponsor = $("#sponsor_change").val().trim();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                url: "{{ asset('frontdata/fetchsponsor2') }}",
                method: "POST",
                data: {sponsor: sponsor, _token: _token},
                success: function (response)
                {
                    if (response) {
                        $("#sponsor_response").html(response);
                    } else {
                        $("#sponsor_response").html('Invalid Sponsor ID');
                    }
                }
            })
        }
    });
    
    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Reject Reason",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reject it!',
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value != '') {
                        resolve()
                    } else {
                        resolve('Reason Required...')
                    }
                })
            }
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "{{ URL::asset('topuppackages/rejecteentry') }}",
                    data: {'row_id': $(this).attr('id'), 'reason': result.value},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.approved_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Text",
            icon: 'success',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Approve it!',
        }).then((result) => {
            $.ajax({
                url: "{{ URL::asset('topuppackages/approveentry') }}",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        });
    });

</script>
@endsection
