@extends('layouts.user')

@section('content')
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Approve Payement User</h1>
    <a href="{{asset('wallet/cashrequestadmin')}}" class="float-right">Back to List</a>
</div>
<div class="row justify-content-center">
    <div class="col-lg-7">
        <form>
            <div class="mb-3">
                <label class="form-label"><strong>User Name :- </strong></label>
                {{$record->getUser->username}}
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Request Amount :- </strong></label>
                {{$record->amount}}
            </div>
            <div class="mb-3">
                <label class="form-label"><strong>Bank Details :- </strong></label>
                <?php
                $bank = \App\BankAccount::find($record->bank_id);
                if ($bank) {
                    $html = 'holder name : ' . $bank->holder_name . '<br>';
                    $html .= 'bank name : ' . $bank->bank_name . '<br>';
                    $html .= 'Account No. : ' . $bank->number . '<br>';
                    $html .= 'branch name : ' . $bank->branch_name . '<br>';
                    $html .= 'ifsc_code : ' . $bank->ifsc_code . '<br>';
                    echo $html;
                }
                ?>
            </div>
        </form>
        <form method="POST" enctype="multipart/form-data" action="{{ asset('wallet/approvecashrequestsave') }}" class="user" id="purchaseform">
            @csrf
            {{ csrf_field() }}
            <input type="hidden" class="form-control" name="username" required  value="{{$record->getUser->username}}">
            <input type="hidden" class="form-control" name="cashrequest" required  value="cashrequest">
            <input type="hidden" class="form-control" name="cash_id" required  value="{{$record->id}}">
            <div>
                <div class="mb-3">
                    <label class="form-label"><strong>Payment Amount</strong></label>
                    <input class="form-control " type="number" maxlength="9" readonly style="width:200px;" value="{{$record->amount}}" name="payment_amount" required>
                </div>
                <div class="mb-3">
                    <label class="form-label"><strong>Payment Date</strong></label>
                    <input class="form-control" type="date" style="width:200px;" name="payment_date" required>
                </div>
                <div class="mb-3">
                    <label class="form-label"><strong>Mode of Payment</strong></label><br>
                    <input type="radio" name="payment_mode"  value="Cash" required/> Cash
                    <input type="radio" name="payment_mode" value="Bank Transfer" required/> Bank Transfer
                    <input type="radio" name="payment_mode" value="UPI" required /> UPI
                </div>  
                <div class="mb-3">
                    <label class="form-label"><strong>Upload Transaction Proof</strong></label>
                    <input class="form-control " type="file" placeholder="Transaction ID" name="payment_proof" accept="image/*">
                </div>
                <div class="mb-3">
                    <label class="form-label"><strong>Remark Text</strong></label>
                    <input class="form-control " type="text" placeholder="Remark Text" name="pay_info">
                </div>
                <button id="sponsor_blance_no"  class="btn btn-primary btn-user w-100" type="submit" style="display:none;border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Submit</button>
                <hr>
            </div>
            <button class="btn btn-primary d-block btn-user w-100" type="submit" style="border-radius: 8px;background: #4f7bf9;font-size: 16px;font-weight: bold;">Submit</button>
            <hr>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {

        $(function () {
            $('#purchaseform_ss').validate({
                errorElement: 'span',
                errorPlacement: function (error, element) {
                    error.addClass('invalid-feedback');
                    error.insertAfter(element);
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });
        });
    });
</script>
@endsection

