<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class WalletRequest extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'wallet_request';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['package_id', 'user_id', 'package_name', 'amount', 'mode', 'note',
        'transaction_id', 'payment_proof', 'wallet_address', 'status', 'reason','number_of_day','roi_per',
        'approve_date', 'add_type', 'monthly_income', 'referral_roi', 'package_roi',
        'expired', 'gold_rate', 'qty',];

    //protected $guarded = array();

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    function getPackage() {
        return $this->belongsTo('\App\Product', 'package_id');
    }

    static function amountFormat($number) {

        $decimal = (string) ($number - floor($number));
        $money = floor($number);
        $length = strlen($money);
        $delimiter = '';
        $money = strrev($money);

        for ($i = 0; $i < $length; $i++) {
            if (( $i == 3 || ($i > 3 && ($i - 1) % 2 == 0) ) && $i != $length) {
                $delimiter .= ',';
            }
            $delimiter .= $money[$i];
        }

        $result = strrev($delimiter);
        $decimal = preg_replace("/0\./i", ".", $decimal);
        $decimal = substr($decimal, 0, 3);

        if ($decimal != '0') {
            $result = $result . $decimal;
        }

        return $result;
    }

}
