<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Wallet extends Model {

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $table = 'wallet';
    protected $fillable = ['user_id', 'amount', 'total_amount', 'flag', 'text', 'pay_date', 'pay_mode', 'pay_id', 'pay_info'];

    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    static function getTotalCashWalletblance() {

        $wallet_plus = \App\Wallet::where('flag', 0)->sum('total_amount');
        $wallet_minus = \App\Wallet::where('flag', 1)->sum('total_amount');

        $walletplus = $wallet_plus ? $wallet_plus : 0;
        $walletminus = $wallet_minus ? $wallet_minus : 0;
        $retun = $walletplus != 0 ? $walletplus - $walletminus : 0;
        return $retun;
    }

    static function getWalletblance($user_id) {
        $user = User::where('id', $user_id)->first();
        if ($user->active == 0) {
            return 0;
        }
        $wallet_plus = \App\Wallet::where('user_id', $user_id)->where('flag', 0)->sum('total_amount');
        $wallet_plus = $wallet_plus - ($wallet_plus * 10 / 100);
        $wallet_minus = \App\Wallet::where('user_id', $user_id)->where('flag', 1)->sum('total_amount');

        $walletplus = $wallet_plus ? $wallet_plus : 0;
        $walletminus = $wallet_minus ? $wallet_minus : 0;
        $retun = round($walletplus, 2) - round($walletminus, 2);
        
        $hold_amount = \App\CashRequest::where('user_id', $user_id)->where('status', 0)->sum('amount');
        
        return $retun - $hold_amount;
    }

    static function getTotalearnings($user_id) {
        $wallet_plus = \App\Wallet::where('user_id', $user_id)->where('flag', 0)
                        ->selectRaw('sum(amount) as amount')->groupBy('user_id')->first();

        $walletplus = $wallet_plus ? $wallet_plus->amount : 0;

        return $walletplus;
    }

    static function getthisweek($user_id) {

        $start_week = date('Y-m-d', strtotime('last sunday'));

        $wallet_plus = \App\Wallet::where('user_id', $user_id)->whereDate('created_at', $start_week)->where('flag', 0)->sum('total_amount');

        $walletplus = $wallet_plus ? $wallet_plus : 0;

        return $walletplus;
    }

    static function getWalletblancetillnow($user_id) {
        $user = User::where('id', $user_id)->first();
        if ($user->active == 0) {
            return 0;
        }

        $wallet_minus = \App\Wallet::where('user_id', $user_id)->where('flag', 1)->sum('total_amount');
        $walletminus = $wallet_minus ? $wallet_minus : 0;
        return $walletminus;
    }

}
