<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UserLevel extends Model {

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $table = 'user_level';
    protected $fillable = ['user_id', 'level', 'sub_user_id', 'wallet_request_id', 'referral_roi', 'status'];

    public function getUser() {
        return $this->belongsTo('App\User', 'user_id', 'id');
    }

    public function getsubUser() {
        return $this->belongsTo('App\User', 'sub_user_id', 'id');
    }

    public function getSponsor() {
        return $this->belongsTo('App\User', 'sponsor_id', 'id');
    }
    
    function getPackage() {
        return $this->belongsTo('\App\Product', 'package_id');
    }

}
