<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable implements MustVerifyEmail {

    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'username', 'name', 'last_name', 'email', 'country_code', 'mobile', 'rights', 'password', 'token', 'active', 'profile_image', 'set_position',
        'sponser', 'suspend', 'gold_price', 'booster_income', 'booster_a', 'booster_b', 'block', 'withdrawal_btn'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    function getboostera() {
        return $this->belongsTo('\App\WalletRequest', 'booster_a', 'id');
    }

    function getboosterb() {
        return $this->belongsTo('\App\WalletRequest', 'booster_b', 'id');
    }

    function getSponser() {
        return $this->belongsTo('\App\User', 'sponser_id');
    }

    public function getsponsorid() {
        return $this->belongsTo('App\User', 'sponser_id', 'id');
    }

    public function getActivationDate($username) {
        $date = ActivationHistory::where('username', $username)->first();
        if ($date) {
            return date('d-m-Y', strtotime($date->created_at));
        }
        return '';
    }

    static function getMyinnerlist($placed_id) {
        $userlist = User::whereIn('sponser_id', $placed_id)->orderBy('id', 'asc')->pluck('id', 'id')->all();
        $html = $userlist;
        if (count($userlist) > 0) {
            $html += self::getMyinnerlist($userlist);
        }
        return $html;
    }

    static function getSilverDepth($categorys, $count) {
        $userlist = SilverAchiever::whereIn('parent_id', $categorys)->orderBy('date', 'asc')->pluck('user_id', 'user_id')->all();
        $html[] = implode(',', $userlist);
        //$count++;
        if (count($userlist) > 0) {
            $count++;
            $html['level_' . $count] = self::getSilverDepth($userlist, $count);
        }
        return $html;
    }

    static function getDepth($categorys, $array, $count) {
        $userlist = User::whereIn('sponser_id', $categorys)->orderBy('id', 'asc')->pluck('id', 'id')->all();
        $html[] = implode(',', $userlist);
        //$count++;
        if (count($userlist) > 0) {
            $count++;
            $html['level_' . $count] = self::getDepth($userlist, $array, $count);
        }
        return $html;
    }

    static function array_flatten($array) {
        if (!is_array($array)) {
            return FALSE;
        }
        $result = array();
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $arrayList = self::array_flatten($value);
                foreach ($arrayList as $listItem) {
                    $result[] = $listItem;
                }
            } else {
                $result[$key] = explode(',', $value);
            }
        }

        return $result;
    }

    function getBanks() {
        return $this->hasMany('\App\BankAccount', 'user_id');
    }

    static function rightlist() {
        return ['subadmin' => 'Sub Admin', 'addnewuser' => 'Add New User',
            'usermanage' => 'User Manage', 'levelreport' => 'Level Report',
            'packages' => 'Packages', 'packagerequest' => 'Package Request', 'faqs' => 'Faqs',
            'termcondition' => 'Term Condition', 'privacypolicy' => 'Privacy Policy'];
    }

}
