<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class RoiIncome extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'roi_income';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['user_id', 'wallet_request_id', 'package_name', 'date', 'days', 'status', 'amount','charges','net_amount'];

    //protected $guarded = array();

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    function getreferralid() {
        return $this->belongsTo('\App\User', 'referral_id');
    }

    function getPackage() {
        return $this->belongsTo('\App\Product', 'package_id');
    }

    static function BusinessVolume($user_id) {

        $user_level_1 = \App\UserLevel::where('user_id', $user_id)->whereIn('level', [1, 2])->pluck('sub_user_id', 'sub_user_id')->all();
        $my_team = \App\User::getMyinnerlist([$user_id]);
        
        return \App\WalletRequest::whereIn('user_id', $my_team)->whereIn('user_id',$user_level_1)->sum('amount');

        $roi_income_team = \App\RoiIncome::whereIn('user_id', $my_team)->where('status', 1)->sum('amount');
        $refer_roi_team = \App\ReferralRoi::whereIn('user_id', $my_team)->where('status', 1)->sum('amount');
        $booster_income = \App\BoosterIncome::whereIn('user_id', $my_team)->where('status', 1)->sum('amount');

        return $roi_income_team + $refer_roi_team + $booster_income;
    }

}
