<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeEmail extends Mailable {

    use Queueable,
        SerializesModels;

    public $userdata;

    public function __construct($userdata) {
        $this->userdata = $userdata;
    }

    public function build() {
        return $this->view('emails.welcome')
                        ->subject('Welcome')
                        ->with([
                            'user' => $this->userdata
        ]);
    }

}
