<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\View\View;
use Yajra\DataTables\DataTables;
use App\User;
use App\Bank;
use App\State;

class TopUpController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    function getSetgoldrate() {

        /*
          $user = User::find(1);
          $all = \App\WalletRequest::all();

          $array = [];
          $j = 1;
          for ($i = 10000; $i < 2000000; $i += 10000) {
          $array[$j] = $i;
          $j++;
          }
          foreach ($all as $row) {
          if (in_array($row->amount, $array)) {
          $Gold_unit = array_search($row->amount, $array);
          }
          $row->update(['qty' => $Gold_unit, 'gold_rate' => $user->gold_price]);
          }
         */
        $data['user'] = User::where('id', 1)->first();
        return \View::make('set_gold_price', $data);
    }

    function postSavegoldprive() {
        $user = User::where('id', 1)->first();
        if ($user) {
            $gold = str_replace(',', '', request('gold_price'));
            $user->update(['gold_price' => $gold]);
        }
        return \Redirect::back()->with('success', 'Saved Successfully...');
    }

    function getPurchase($id) {
        $data['packages'] = \App\Product::where('id', $id)->first();
        return \View::make('package_purchase', $data);
    }

    function postPurchasesave(Request $request) {

        $request->validate([
            'payment_proof' => 'required|mimes:png,jpg,jpge',
            'pack_id' => 'required',
        ]);

        $find = \App\Product::where('id', request('pack_id'))->first();
        if ($find) {
            $user = User::find(1);
            $payment_proof = null;
            if ($request->hasFile('payment_proof')) {
                $file = $request->file('payment_proof');
                $destinationPath = public_path() . '/payment_proof/';
                $payment_proof = \Str::random(10) . '.' . $file->getClientOriginalExtension();
                $file->move($destinationPath, $payment_proof);
            }

            \App\WalletRequest::create(['package_id' => $find->id, 'user_id' => \Auth::user()->id, 'package_name' => $find->package_name,
                'amount' => $find->mrp, 'roi_per' => $find->roi_per, 'number_of_day' => $find->number_of_day,
                'transaction_id' => $request->transaction_id, 'wallet_address' => $request->wallet_address, 'payment_proof' => $payment_proof, 'status' => 0]);

            return \Redirect::to('topuppackages/mypackages')->with('success', 'Your Request Send Successfully...');
        }
    }

    function getMypackages() {
        $data['user'] = User::find(\Auth::user()->id);
        $data['packages'] = \App\WalletRequest::where('user_id', \Auth::user()->id)->get();
        return \View::make('wallet_request', $data);
    }

    function getUserpackages($id) {

        $data['packages'] = \App\WalletRequest::where('user_id', $id)->get();
        $data['user'] = User::find($id);
        return \View::make('wallet_request', $data);
    }

    function getMyinvoice() {
        $data['packages'] = \App\WalletRequest::where('user_id', \Auth::user()->id)->where('status', 1)->get();
        return \View::make('my_invoice_list', $data);
    }

    function getDownloadinvice($id) {
        $data['packages'] = \App\WalletRequest::where('user_id', \Auth::user()->id)->where('id', $id)->first();
        $data['user'] = $data['packages']->getUser;

        //return \View::make('my_invoice', $data);
        $pdf = \Pdf::loadView('my_invoice', $data);
        return $pdf->setOption('isRemoteEnabled', TRUE)
                        ->setOption(['dpi' => 150, 'defaultFont' => 'sans-serif'])->download('invoice.pdf');
    }

    function getRemovetopuprequest($id) {
        $packages = \App\WalletRequest::where('user_id', \Auth::user()->id)->where('id', $id)->first();
        if ($packages) {
            $packages->delete();
        }
        return \Redirect::back();
    }

    function getTopuppackage() {
        $data['packages'] = \App\Product::orderBy('mrp', 'asc')->get();

        return \View::make('admin.member_activation', $data);
    }

    function postActivemembermanuly(Request $request) {

        $this->validate($request, [
            'username' => 'required|exists:users,username',
            'amount' => 'required',
            'created_at' => 'required'
        ]);
        $array = [];
        $j = 1;
        for ($i = 100000; $i < 2000000; $i += 100000) {
            $array[$j] = $i;
            $j++;
        }
        if (in_array($request->amount, $array)) {
            $Gold_unit = array_search($request->amount, $array);
        } else {
            return \Redirect::back()->with('error', 'Amount Not Valid...');
        }
        $user = User::where('username', $request->username)->first();
        if ($user) {
            $usermain = User::find(1);
            $join_date = date('Y-m-d H:i:s', strtotime(request('created_at')));
            $invest = new \App\WalletRequest();
            $invest->user_id = $user->id;
            $invest->package_name = $Gold_unit . ' RTG Unit';
            $invest->amount = $request->amount;
            $invest->qty = $Gold_unit;
            $invest->status = 1;
            $invest->reason = $request->reason;
            $invest->add_type = 1;
            $invest->approve_date = $join_date;
            $invest->created_at = $join_date;
            $invest->updated_at = $join_date;
            $invest->save();

            return \Redirect::back()->with('success', 'Member ' . $request->username . ' Activated Successfully... with Package - ' . $Gold_unit . ' RTG Unit');
        }
        return \Redirect::back()->with('error', 'Somthing Wrong..');
    }

    function getMemberactivation() {
        $data['cash_amount'] = round(\App\CashWallet::getWalletblance(\Auth::user()->id));
        $data['packages'] = \App\Product::orderBy('mrp', 'asc')->get();
        return \View::make('packages_list', $data);
    }

    function getRequestslist() {
        $data['panding'] = \App\WalletRequest::where('status', 0)->get();
        $data['approved'] = \App\WalletRequest::where('status', 1)->get();
        $data['rejected'] = \App\WalletRequest::where('status', 2)->get();
        return \View::make('admin.wallet_request_admin', $data);
    }

    function postRejecteentry(Request $request) {
        $find = \App\WalletRequest::where('id', $request->row_id)->first();
        if ($find) {
            $find->update(['status' => 2, 'reason' => $request->reason, 'approve_date' => date('Y-m-d H:i:s')]);
        }
        return \Response::json(['code' => 200]);
    }

    function postApproveentry(Request $request) {
        $find = \App\WalletRequest::where('id', $request->row_id)->first();
        if ($find) {
            if ($find->mode == 'Wallet') {
                $charges = $find->amount * 5 / 100;
                $total_amount = $find->amount + $charges;
                \App\CashWallet::create(['user_id' => $find->user_id, 'amount' => $find->amount, 'charges' => $charges, 'total_amount' => $total_amount, 'flag' => 1,
                    'text' => 'Debit Topup Amount + 5% Charges']);
            }
            $find->update(['status' => 1, 'reason' => $request->reason, 'approve_date' => date('Y-m-d H:i:s')]);
            $user = \App\User::where('id', $find->user_id)->first();
            if ($user) {
                if ($user->active == 0) {
                    \App\User::where('id', $find->user_id)->update(['active' => 1]);
                }
                if ($user->block == 1) {
                    \App\User::where('id', $find->user_id)->update(['block' => 0]);
                }
            }
        }
        return \Response::json(['code' => 200]);
    }

    function getDownloadalloverview($id) {

        $data['row'] = \App\GoldScheme::where('id', $id)->first();

        $data['allrows'] = \App\GoldScheme::where('unit_group', $data['row']->unit_group)->get();

        return \PDF::loadView('income.goldscheme_recipt', $data)
                        ->setPaper('a4', 'portrait')->stream();

        return \View::make('income.goldscheme_recipt', $data);
    }

}
