<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use Image;
use Yajra\DataTables\DataTables;

class ProductController extends Controller {

    public function __construct() {
        $this->middleware('auth', ['except' => ['postPackagedetails']]);
    }

    public function transformDate($value, $format = 'Y-m-d') {
        try {
            return \Carbon\Carbon::instance(\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($value));
        } catch (\ErrorException $e) {
            return \Carbon\Carbon::createFromFormat($format, $value);
        }
    }

    public function getIndex() {
        $data['page_header'] = 'Package Management';
        $data['plans'] = \App\ProductPlan::all();
        return view('admin.packages', $data);
    }

    public function getReferralplan() {
        $data['page_header'] = 'Referral Plan';
        return view('admin.packages_plan', $data);
    }

    function getData() {
        $users = Product::select('*');
        return Datatables::of($users)
                        ->editColumn('plan', function ($user) {
                            $pla = \App\ProductPlan::where('id',$user->plan)->first();
                            if($pla)
                            {
                                return $pla->code.' / '.$pla->name;
                            }
                            return '';
                        })
                        ->addColumn('action', function ($user) {
                            return '<a href="javascript:;" class="btn btn-sm btn-outline-primary update_btn" id="' . $user->id . '"><i class="fas fa-edit"></i></a>
                            <a href="javascript:;" class="btn btn-sm btn-outline-danger delete_btn" id="' . $user->id . '"><i class="fas fa-trash-alt"></i></a>';
                        })
                        ->rawColumns(['product_image', 'action', 'monthly_roi', 'daily_roi', 'daily_amount', 'monthly_amount'])
                        ->make(true);
    }

    function getPlandata() {
        $users = \App\ProductPlan::select('*');
        return Datatables::of($users)
                        ->addColumn('action', function ($user) {
                            $p = Product::where('plan',$user->id)->first();
                            if($p)
                            {
                                return '<a href="javascript:;" class="btn btn-sm btn-outline-primary update_btn" id="' . $user->id . '"><i class="fas fa-edit"></i></a>';
                            }
                            return '<a href="javascript:;" class="btn btn-sm btn-outline-primary update_btn" id="' . $user->id . '"><i class="fas fa-edit"></i></a>
                            <a href="javascript:;" class="btn btn-sm btn-outline-danger delete_btn" id="' . $user->id . '"><i class="fas fa-trash-alt"></i></a>';
                        })
                        ->rawColumns(['product_image', 'action', 'monthly_roi', 'daily_roi', 'daily_amount', 'monthly_amount'])
                        ->make(true);
    }

    public function postSaveproduct(Request $request) {
        if (request('update_id')) {
            $product = Product::where('id', request('update_id'))->first();
        } else {
            $product = new Product();
        }

        $product->package_name = $request->package_name;
        $product->code = $request->code;
        $product->usdt = $request->usdt;
        $product->mrp = $request->mrp;
        $product->security = $request->security;
        $product->roi_per = $request->roi_per;
        $product->number_of_day = $request->number_of_day;
        $product->calculation = $request->calculation;
        $product->payout = $request->payout;
        $product->plan = $request->plan;
        $product->extra_info = $request->extra_info;
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $destinationPath = public_path() . '/package_img/';
            $filename1 = \Str::random(10) . '.' . $image->getClientOriginalExtension();
            $image->move($destinationPath, $filename1);
            $product->product_image = $filename1;
        }
        $product->save();

        return \Redirect::back();
    }

    public function postSaveplan(Request $request) {
        if (request('update_id')) {
            $product = \App\ProductPlan::where('id', request('update_id'))->first();
        } else {
            $product = new \App\ProductPlan();
        }
        $product->code = $request->code;
        $product->name = $request->name;
        $product->days = $request->days;
        $product->level_1 = $request->level_1;
        $product->level_2 = $request->level_2;
        $product->level_3 = $request->level_3;
        $product->level_4 = $request->level_4;
        $product->level_5 = $request->level_5;
        $product->level_6 = $request->level_6;
        $product->level_7 = $request->level_7;
        $product->level_8 = $request->level_8;
        $product->level_9 = $request->level_9;
        $product->level_10 = $request->level_10;
        $product->level_11 = $request->level_11;
        $product->save();

        return \Redirect::back();
    }

    public function postEditdata() {
        $product = Product::find(request('row_id'));
        if ($product) {
            return \Response::json(['row' => $product]);
        }
    }

    public function postEditplandata() {
        $product = \App\ProductPlan::find(request('row_id'));
        if ($product) {
            return \Response::json(['row' => $product]);
        }
    }

    public function postDelete() {
        $product = Product::find(request('row_id'));
        if ($product) {
            $location = public_path('package_img/' . $product->product_image);
            \File::delete($location);
            $product->delete();
        }
        return \Redirect::back();
    }

    public function postDeleteplan() {
        $product = \App\ProductPlan::find(request('row_id'));
        if ($product) {
            $product->delete();
        }
        return \Redirect::back();
    }

}
