<?php

namespace App\Http\Controllers;

use Auth;
use App\Bank;
use Illuminate\Http\Request;

class KycController extends Controller {
    /**
     * Show bank details
     */

    /**
     * Show a form to create bank details
     */
    public function getIndex() {
        $user_id = \Auth::user()->id;
        
        $data['banks'] = Bank::all();
        $data['user'] = \App\User::find(request('user_id'));
        
        if (\Auth::user()->role == 1) {
            if (request('user_id')) {
                $data['kycs'] = \App\KycDetails::where('user_id', request('user_id'))->get();
            } else {
                $data['kycs'] = \App\KycDetails::where('status', 0)->get();
            }
            $data['page_header'] = 'Kyc Requests';
            return view('kyc_admin', $data);
        } else {
            $data['page_header'] = 'Kyc Uploads';
            $data['user'] = \App\User::find(\Auth::user()->id);
            $data['kycs'] = \App\KycDetails::where('user_id', \Auth::user()->id)->get();
            return view('kyc', $data);
        }
    }

    public function getApproved(Request $request, $id) {
        \App\KycDetails::where('id', $id)->update(['status' => 1]);
        return back();
    }

    public function getReject(Request $request, $id) {
        \App\KycDetails::where('id', $id)->update(['status' => 2]);
        return back();
    }

    public function getRejecteddelete(Request $request, $id) {
        $find = \App\KycDetails::where('id', $id)->first();
        if ($find) {
            $destinationPath = public_path() . '/kyc_doc/' . $find->file;
            \File::delete($destinationPath);
            $find->delete();
        }
        return \Redirect::to('kyc');
    }

    public function postUpload(Request $request) {

        $request->validate([
            'type' => 'required',
            'file' => 'required|mimes:png,jpg,jpge',
        ]);

        if ($request->hasFile('file')) {
            $file = $request->file;
            $destinationPath = public_path() . '/kyc_doc/';
            $filename1 = \Str::random(10) . '.' . $file->getClientOriginalExtension();

            $file = $request->file('file');
            $file->move($destinationPath, $filename1);

            //$createImage = \Image::make($file)->save($destinationPath . $filename1);

            \App\KycDetails::create(['user_id' => \Auth::user()->id, 'type' => $request->type, 'file' => $filename1, 'status' => 0]);
        }
        return back()->with('success', 'You have successfully upload file.');
    }

}
