<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;

class CashWalletCronSet extends Command {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cashwalletset:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Amount Transfer Active Wallet to cash Wallet';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle() {
        try {
            \DB::transaction(function() {
                $users = User::where('role', 2)->where('active', 1)->get();
                foreach ($users as $user) {
                    $array[] = '2024-3-17';
                    $array[] = '2024-3-24';
                    $array[] = '2024-3-31';
                    foreach ($array as $final_date) {

                        $wallet_plus = \App\Wallet::where('user_id', $user->id)->whereDate('created_at', '<=', date('Y-m-d', strtotime($final_date)))->where('flag', 0)->sum('total_amount');
                        $wallet_minus = \App\Wallet::where('user_id', $user->id)->whereDate('created_at', '<=', date('Y-m-d', strtotime($final_date)))->where('flag', 1)->sum('total_amount');

                        $walletplus = $wallet_plus ? $wallet_plus : 0;
                        $walletminus = $wallet_minus ? $wallet_minus : 0;
                        $amount = round($walletplus, 2) - round($walletminus, 2);

                        if ($amount > 0) {
                            $my_package = \App\WalletRequest::where('status', 1)->where('user_id', $user->id)->first();
                            if ($my_package) {
                                $tds = $amount * 5 / 100;
                                $tds_carge = round($tds, 2);

                                $sc = $amount * 10 / 100;
                                $sc_carge = round($sc, 2);

                                $total_charge = $tds_carge + $sc_carge;

                                $netpaymemt = $amount - $total_charge;

                                $wallet = new \App\Wallet();
                                $wallet->user_id = $user->id;
                                $wallet->amount = $amount;
                                $wallet->total_amount = $netpaymemt;
                                $wallet->flag = 1;
                                $wallet->text = 'Amount Transfer Cash Wallet';
                                $wallet->created_at = date('Y-m-d H:i:s', strtotime($final_date));
                                $wallet->updated_at = date('Y-m-d H:i:s', strtotime($final_date));
                                $wallet->save();

                                $wallet = new \App\Wallet();
                                $wallet->user_id = $user->id;
                                $wallet->amount = $total_charge;
                                $wallet->total_amount = $total_charge;
                                $wallet->flag = 1;
                                $wallet->text = 'Amount Transfer Cash Tds/Sc Charges';
                                $wallet->created_at = date('Y-m-d H:i:s', strtotime($final_date));
                                $wallet->updated_at = date('Y-m-d H:i:s', strtotime($final_date));
                                $wallet->save();

                                $wallet = new \App\CashWallet();
                                $wallet->user_id = $user->id;
                                $wallet->amount = $amount;
                                $wallet->charges = $total_charge;
                                $wallet->total_amount = $netpaymemt;
                                $wallet->flag = 0;
                                $wallet->text = 'Amount Added From Active Wallet';
                                $wallet->created_at = date('Y-m-d H:i:s', strtotime($final_date));
                                $wallet->updated_at = date('Y-m-d H:i:s', strtotime($final_date));
                                $wallet->save();
                            }
                        }
                    }
                }
            });
        } catch (Exception $ex) {
            
        }
        echo 'All Calculation Done...';
        exit;
        try {
            \DB::transaction(function() {
                $users = User::where('role', 2)->where('active', 1)->get();
                foreach ($users as $user) {
                    $amount = \App\Wallet::getWalletblance($user->id);
                    if ($amount > 0) {
                        $my_package = \App\WalletRequest::where('status', 1)->where('user_id', $user->id)->first();
                        if ($my_package) {
                            $tds = $amount * 5 / 100;
                            $tds_carge = round($tds, 2);

                            $sc = $amount * 10 / 100;
                            $sc_carge = round($sc, 2);

                            $total_charge = $tds_carge + $sc_carge;

                            $netpaymemt = $amount - $total_charge;

                            \App\Wallet::create(['user_id' => $user->id, 'amount' => $amount, 'total_amount' => $netpaymemt, 'flag' => 1,
                                'text' => 'Amount Transfer Cash Wallet']);

                            \App\Wallet::create(['user_id' => $user->id, 'amount' => $total_charge, 'total_amount' => $total_charge, 'flag' => 1,
                                'text' => 'Amount Transfer Cash Tds/Sc Charges']);

                            \App\CashWallet::create(['user_id' => $user->id, 'amount' => $amount, 'charges' => $total_charge, 'total_amount' => $netpaymemt, 'flag' => 0,
                                'text' => 'Amount Added From Active Wallet']);
                        }
                    }
                }
            });
        } catch (Exception $ex) {
            
        }
        echo 'All Calculation Done...';
    }

}
