<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;

class BoosterCron extends Command {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'booster:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'calculate add balance in wallet...';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle() {
        $this->addbalance();

        \App\CheckCron::create(['text' => 'Boostr Check Cron']);
//        echo 'All Calculation Done...';
    }

    function addbalance() {

        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '3000');

        \DB::transaction(function() {
            $users = \App\User::where('active', 1)->where('id', '!=', 1)->where('booster_income', 0)->get();
            foreach ($users as $u) {

                $direct_count = \App\User::where('active', 1)->where('sponser_id', $u->id)->get()->count();
                if ($direct_count >= 2) {
                    $direct_list = \App\User::where('active', 1)->where('sponser_id', $u->id)->pluck('id', 'id')->all();

                    $first_A = \App\WalletRequest::whereIn('user_id', $direct_list)->where('status', 1)->orderBy('approve_date')->first();

                    $second_B = \App\WalletRequest::whereIn('user_id', $direct_list)->where('status', 1)->where('id', '!=', $first_A->id)->orderBy('amount', 'DESC')->first();
                    if ($first_A->amount != $second_B->amount) {
                        if ($first_A->amount >= $second_B->amount) {
                            $get_roi = $first_A;
                        } else {
                            $get_roi = $second_B;
                        }

                        $date_approve = date('Y-m-d');

                        $roi_income = \App\RoiIncome::where('user_id', $get_roi->user_id)
                                        ->where('wallet_request_id', $get_roi->id)->where('days', '<=', 40)->get();
                        foreach ($roi_income as $mincome) {
                            $amount = $mincome->amount * 25 / 100;
                            $date_approve = date('Y-m-d', strtotime("+1 day", strtotime($date_approve)));
                            if (date('l', strtotime($date_approve)) == "Sunday") {
                                $date_approve = date('Y-m-d', strtotime("+1 day", strtotime($date_approve)));
                            }
                            \App\BoosterIncome::create(['user_id' => $u->id, 'referral_id' => $get_roi->user_id,
                                'wallet_request_id' => $get_roi->id,
                                'date' => $date_approve, 'amount' => $amount, 'status' => 0, 'days' => $mincome->days]);
                        }
                        $u->update(['booster_income' => 1, 'booster_a' => $first_A->id, 'booster_b' => $second_B->id]);
                    }
                }
            }
            $refer_roi = \App\BoosterIncome::whereDate('date', '<=', date('Y-m-d'))->where('status', 0)->get();
            foreach ($refer_roi as $week) {
                if ($week->getUser) {
                    if ($week->getUser->block == 0) {
                        if ($week->getreferralid->suspend == 0) {
                            $name = $week->getreferralid ? $week->getreferralid->name : '';
                            $wallet = new \App\Wallet();
                            $wallet->user_id = $week->user_id;
                            $wallet->amount = $week->amount;
                            $wallet->total_amount = $week->amount;
                            $wallet->flag = 0;
                            $wallet->text = 'Booster Income For User ' . $name . ' Amount Added ' . $week->date;
                            $wallet->created_at = date('Y-m-d H:i:s', strtotime($week->date));
//                                $wallet->created_at = date('Y-m-d H:i:s');
                            $wallet->updated_at = date('Y-m-d H:i:s', strtotime($week->date));
                            $wallet->save();

                            $week->update(['status' => 1]);
                        }
                    } else {
                        $week->update(['status' => 2]);
                    }
                }
            }
        });
    }

}
