<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CashWallet extends Model {

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $table = 'cash_wallet';
    protected $fillable = ['user_id', 'amount', 'charges', 'total_amount', 'flag', 'text', 'pay_date', 'pay_mode', 'pay_id', 'pay_info'];

    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    static function getTotalCashWalletblance() {

        $wallet_plus = \App\CashWallet::where('flag', 0)->sum('total_amount');
        $wallet_minus = \App\CashWallet::where('flag', 1)->sum('total_amount');

        return $retun = round($wallet_plus, 2) - round($wallet_minus, 2);
    }

    static function getWalletblance($user_id) {
        $user = User::where('id', $user_id)->first();
        if ($user->active == 0) {
            return 0;
        }
        $wallet_plus = \App\CashWallet::where('user_id', $user_id)->where('flag', 0)->sum('total_amount');
        $wallet_minus = \App\CashWallet::where('user_id', $user_id)->where('flag', 1)->sum('total_amount');

        $retun = round($wallet_plus, 2) - round($wallet_minus, 2);

        $hold_amount = \App\CashRequest::where('user_id', $user_id)->where('status', 0)->sum('amount');

        $hold_amount_2 = \App\WalletRequest::where('user_id', $user_id)->where('mode', 'Wallet')->where('status', 0)->sum('amount');
        $Sc = $hold_amount_2 * 5 / 100;
        $hold_amount_2 = $hold_amount_2 + $Sc;
        $retun = $retun - $hold_amount_2;

        return $retun - $hold_amount;
    }

    static function getTotalearnings($user_id) {
        $wallet_plus = \App\CashWallet::where('user_id', $user_id)->where('flag', 0)
                        ->selectRaw('sum(total_amount) as total_amount')->groupBy('user_id')->first();

        $walletplus = $wallet_plus ? $wallet_plus->total_amount : 0;

        return $walletplus;
    }

}
