<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CashRequest extends Model {

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $table = 'cash_request';
    protected $fillable = ['user_id', 'amount', 'sc', 'bank_id', 'cash_amount', 'date_time', 'status', 'reason', 'address', 'payment_proof', 'transaction_id'];

    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    static function getWalletblance($user_id) {
        $user = User::where('id', $user_id)->first();
        if ($user->active == 0) {
            return 0;
        }
        $wallet_plus = \App\CashWallet::where('user_id', $user_id)->where('flag', 0)->sum('total_amount');

        $wallet_minus = \App\CashWallet::where('user_id', $user_id)->where('flag', 1)->sum('total_amount');

        $walletplus = $wallet_plus ? $wallet_plus : 0;

        $walletminus = $wallet_minus ? $wallet_minus : 0;

        $retun = $walletplus != 0 ? $walletplus - $walletminus : 0;
        return $retun;
    }

    static function getWalletblancetillnow($user_id) {
        $user = User::where('id', $user_id)->first();
        if ($user->active == 0) {
            return 0;
        }

        $wallet_minus = \App\CashWallet::where('user_id', $user_id)->where('flag', 1)->sum('total_amount');
        $walletminus = $wallet_minus ? $wallet_minus : 0;
        return $walletminus;
    }

    static function getTotalearnings($user_id) {
        $wallet_plus = \App\CashWallet::where('user_id', $user_id)->where('flag', 0)->sum('total_amount');

        $walletplus = $wallet_plus ? $wallet_plus : 0;

        return $walletplus;
    }

    static function getthisweek($user_id) {

        $start_week = date('Y-m-d', strtotime('last sunday'));

        $wallet_plus = \App\CashWallet::where('user_id', $user_id)->whereDate('created_at', $start_week)->where('flag', 0)->sum('total_amount');

        $walletplus = $wallet_plus ? $wallet_plus : 0;

        return $walletplus;
    }

}
