<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BoosterIncome extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'booster_income';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['user_id', 'referral_id', 'level', 'wallet_request_id', 'date', 'days', 'status', 'amount'];

    //protected $guarded = array();

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    function getUser() {
        return $this->belongsTo('\App\User', 'user_id');
    }

    function getreferralid() {
        return $this->belongsTo('\App\User', 'referral_id');
    }

    function getPackage() {
        return $this->belongsTo('\App\Product', 'package_id');
    }

}
