<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankAccount extends Model {

    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id', 'number', 'holder_name', 'branch_name', 'ifsc_code', 'bank_name','payment_type','platform_name','wallet_address',
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    /*
      |--------------------------------------------------------------------------
      | Relations
      |--------------------------------------------------------------------------
     */

    /**
     * Get the bank name of the bank account.
     */
    public function bank() {
        return $this->belongsTo(Bank::class);
    }

    /**
     * Get the user of the bank account.
     */
    public function user() {
        return $this->belongsTo(User::class);
    }

}
