
<?php $__env->startSection('css'); ?>
<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Withdrawal Request</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home"
                   aria-selected="true">Pending Request</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile"
                   aria-selected="false">Approved Request</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact"
                   aria-selected="false">Rejected Request</a>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                <div class="row">
                    <div class="col-md-12">
                        <br>
                        <br>
                        <div class="table-responsive">
                            <table id="Datatable" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="seprator">
                                        <th>Username</th>
                                        <th>Name</th>
                                        <th>Request Date </th>
                                        <th>Bank Details</th>
                                        <th>Payble Amount</th>
                                        <th>Status</th>
                                        <th>Reason</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    <?php $__currentLoopData = $panding; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($row->getUser): ?>
                                    <tr>
                                        <td> <?php echo e($row->getUser->username); ?></td>
                                        <td> <?php echo e($row->getUser->name); ?></td>
                                        <td> <?php echo e(date('d-m-Y H:i',strtotime($row->created_at))); ?></td>
                                        <td>
                                            <?php
                                            $bank = \App\BankAccount::find($row->bank_id);
                                            if ($bank) {
                                                $html = 'holder name : ' . $bank->holder_name . '<br>';
                                                $html .= 'bank name : ' . $bank->bank_name . '<br>';
                                                $html .= 'Account No. : ' . $bank->number . '<br>';
                                                $html .= 'branch name : ' . $bank->branch_name . '<br>';
                                                $html .= 'ifsc_code : ' . $bank->ifsc_code . '<br>';
                                                echo $html;
                                            }
                                            ?>
                                        </td>
                                        <td><?php echo e($row->cash_amount); ?></td>
                                        <td> 
                                            <?php if($row->status == 0): ?>
                                            <span class="text-warning">Pending</span>
                                            <?php elseif($row->status == 1): ?>
                                            <span class="text-success">Success</span>
                                            <?php else: ?>
                                            <span class="text-danger">Rejected</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($row->reason); ?></td>
                                        <td>
                                            <?php if($row->status != 1): ?>
                                            <a href="<?php echo e(asset('wallet/approvecashrequest/'.$row->id)); ?>" class="btn btn-sm btn-success approved_btn_aa" type="button" id="<?php echo e($row->id); ?>">Approved</a>
                                            <button class="btn btn-sm btn-danger delete_btn" type="button" id="<?php echo e($row->id); ?>">Reject</button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php $i++; ?>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                <div class="row">
                    <div class="col-md-12">
                        <br>
                        <br>
                        <div class="table-responsive">
                            <table id="Datatable_2" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="seprator">
                                        <th>Username</th>
                                        <th>Name</th>
                                        <th>Request Date </th>
                                        <th>Bank Details </th>
                                        <th>Payble Amount</th>
                                        <th>Status</th>
                                        <th>Reason</th>
                                        <th>Approve Date/Time</th>
                                        <th>Transaction Id</th>
                                        <th>Payment Proof</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    <?php $__currentLoopData = $approved; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($row->getUser): ?>
                                    <tr>
                                        <td> <?php echo e($row->getUser->username); ?></td>
                                        <td> <?php echo e($row->getUser->name); ?></td>
                                        <td> <?php echo e(date('d-m-Y H:i',strtotime($row->created_at))); ?></td>
                                        <td>
                                            <?php
                                            $bank = \App\BankAccount::find($row->bank_id);
                                            if ($bank) {
                                                $html = 'holder name : ' . $bank->holder_name . '<br>';
                                                $html .= 'bank name : ' . $bank->bank_name . '<br>';
                                                $html .= 'Account No. : ' . $bank->number . '<br>';
                                                $html .= 'branch name : ' . $bank->branch_name . '<br>';
                                                $html .= 'ifsc_code : ' . $bank->ifsc_code . '<br>';
                                                echo $html;
                                            }
                                            ?>
                                        </td>
                                        <td><?php echo e($row->cash_amount); ?></td>
                                        <td> 
                                            <?php if($row->status == 0): ?>
                                            <span class="text-warning">Pending</span>
                                            <?php elseif($row->status == 1): ?>
                                            <span class="text-success">Success</span>
                                            <?php else: ?>
                                            <span class="text-danger">Rejected</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($row->reason); ?></td>
                                        <td>
                                            <?php echo e($row->created_at); ?>

                                        </td>
                                        <td>
                                            <?php echo e($row->transaction_id); ?>

                                        </td>
                                        <td title="View Document" class="pointer">
                                            <a href="<?php echo e(asset('payment_proof/'.$row->payment_proof)); ?>" target="_blank"><i class="fa fa-eye" aria-hidden="true" ></i></a>
                                        </td>
                                    </tr>
                                    <?php $i++; ?>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                <br>
                <br>
                <div class="table-responsive">
                    <table id="Datatable_3" class="table table-bordered table-striped">
                        <thead>
                            <tr class="seprator">
                                <th>Username</th>
                                <th>Name</th>
                                <th>Request Date </th>
                                <th>Bank Details</th>
                                <th>Payble Amount</th>
                                <th>Status</th>
                                <th>Reason</th>
                                <th>Reject Date/Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            <?php $__currentLoopData = $rejected; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($row->getUser): ?>
                            <tr>
                                <td> <?php echo e($row->getUser->username); ?></td>
                                <td> <?php echo e($row->getUser->name); ?></td>
                                <td> <?php echo e(date('d-m-Y H:i',strtotime($row->created_at))); ?></td>
                                <td>
                                    <?php
                                    $bank = \App\BankAccount::find($row->bank_id);
                                    if ($bank) {
                                        $html = 'holder name : ' . $bank->holder_name . '<br>';
                                        $html .= 'bank name : ' . $bank->bank_name . '<br>';
                                        $html .= 'Account No. : ' . $bank->number . '<br>';
                                        $html .= 'branch name : ' . $bank->branch_name . '<br>';
                                        $html .= 'ifsc_code : ' . $bank->ifsc_code . '<br>';
                                        echo $html;
                                    }
                                    ?>
                                </td>
                                <td><?php echo e($row->cash_amount); ?></td>
                                <td> 
                                    <?php if($row->status == 0): ?>
                                    <span class="text-warning">Pending</span>
                                    <?php elseif($row->status == 1): ?>
                                    <span class="text-success">Success</span>
                                    <?php else: ?>
                                    <span class="text-danger">Rejected</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($row->reason); ?></td>
                                <td>
                                    <?php echo e($row->date_time); ?>

                                </td>
                            </tr>
                            <?php $i++; ?>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    var tabledata = $('#Datatable').DataTable();
    var tabledata2 = $('#Datatable_2').DataTable();
    var tabledata3 = $('#Datatable_3').DataTable();

    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Reject Reason",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reject it!',
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value != '') {
                        resolve()
                    } else {
                        resolve('Reason Required...')
                    }
                })
            }
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo e(URL::asset('wallet/rejecteentry')); ?>",
                    data: {'row_id': $(this).attr('id'), 'reason': result.value},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.approved_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Text",
            icon: 'success',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Approve it!',
        }).then((result) => {
            $.ajax({
                url: "<?php echo e(URL::asset('wallet/approveentry')); ?>",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        });
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/cash_request_admin.blade.php ENDPATH**/ ?>