
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Ad Package to member</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card shadow-lg o-hidden border-0">
            <div class="card-body p-0">
                <div class="row">
                    <div class="col-lg-7">
                        <div class="p-5">
                            <form style="font-weight: bold;" id="activationform" action="<?php echo e(asset('topuppackages/activemembermanuly')); ?>" id="quickForm" class="user" method="post" enctype="multipart/form-data">
                                <span class="text-warning">
                                    carefully add User and Select Package.
                                </span>
                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />
                                <div class="form-group">
                                    <label class="form-label">Enter Member ID</label>
                                    <input id="sponsor_change" class="form-control form-control-user" type="text" placeholder="Username" name="username" required>
                                    <div id="sponsor_response"></div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Select Package</label>
                                    <select class="form-control" name="pack_id">
                                        <option value="">Select One</option>
                                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pack): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($pack->id); ?>"><?php echo e($pack->package_name); ?> | RS.<?php echo e($pack->mrp); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Payment Mode - Cash / Bank Transfer</label>
                                    <select class="form-control" id="changetopup" name="mode" required>
                                        <option value="">Select One</option>
                                        <option value="Bank">Bank Transfer</option>
                                        <option value="Cash">Cash</option>
                                        <option value="Credit">Credit</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label"><strong>Upload Transaction Proof</strong></label>
                                    <input class="form-control form-control-user requiredremove" type="file" placeholder="Transaction ID" name="payment_proof" accept="image/*">
                                </div>
                                <div class="form-group">
                                    <label class="form-label">Remarks</label>
                                    <input class="form-control form-control-user" type="text" placeholder="Remarks" name="reason">
                                </div>
                                <hr>
                                <button class="btn btn-primary d-block btn-user w-100 submit_btn" type="submit">Add</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).on('blur', '#sponsor_change', function () {
        if ($(this).val() != '')
        {
            var sponsor = $("#sponsor_change").val().trim();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                url: "<?php echo e(asset('frontdata/fetchsponsor2')); ?>",
                method: "POST",
                data: {sponsor: sponsor, _token: _token},
                success: function (response)
                {
                    if (response) {
                        $("#sponsor_response").html(response);
                    } else {
                        $("#sponsor_response").html('Invalid Sponsor ID');
                    }
                }
            })
        }
    });

    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Reject Reason",
            icon: 'error',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Reject it!',
            inputValidator: (value) => {
                return new Promise((resolve) => {
                    if (value != '') {
                        resolve()
                    } else {
                        resolve('Reason Required...')
                    }
                })
            }
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo e(URL::asset('topuppackages/rejecteentry')); ?>",
                    data: {'row_id': $(this).attr('id'), 'reason': result.value},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        window.location.reload();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.approved_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            input: 'textarea',
            inputPlaceholder: "Enter Text",
            icon: 'success',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, Approve it!',
        }).then((result) => {
            $.ajax({
                url: "<?php echo e(URL::asset('topuppackages/approveentry')); ?>",
                data: {'row_id': $(this).attr('id'), 'reason': result.value},
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                },
                success: function (data)
                {
                    window.location.reload();
                },
                cache: false,
            });
        });
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/member_activation.blade.php ENDPATH**/ ?>