<?php $__env->startSection('content'); ?>
<style>
    .image{
        height: 80px;
    }

</style>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Plan Management </h1>
</div>
<div class="">
    <button class="btn btn-success" id="openaddmodel">
        Add New  Plan <i class="fas fa-plus"></i>
    </button>
    <a class="btn btn-info float-right" href="<?php echo e(asset('packages')); ?>">
        <i class="fa fa-arrow-left"></i> Back To Package
    </a>
    <br>
    <br>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table id="Datatable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Plan Code</th>
                            <th>Plan Name</th>
                            <th>No Of Days</th>
                            <th>Level 1 (in %)</th>
                            <th>Level 2 (in %)</th>
                            <th>Level 3 (in %)</th>
                            <th>Level 4 (in %)</th>
                            <th>Level 5 (in %)</th>
                            <th>Level 6 (in %)</th>
                            <th>Level 7 (in %)</th>
                            <th>Level 8 (in %)</th>
                            <th>Level 9 (in %)</th>
                            <th>Level 10 (in %)</th>
                            <th>Level 11 To 25</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="openaddmodelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Package</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(asset('packages/saveplan')); ?>" id="quickForm" method="post" enctype="multipart/form-data">
                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" />
                <input type="hidden" name="update_id" value="" />
                <div class="modal-body">
                    <!-- Package Name -->
                    <div class="mb-3">
                        <label>Plan Code</label>
                        <input type="text" class="form-control" name="code" required placeholder="Enter Plan Code">
                    </div>
                    <!-- Package Code -->
                    <div class="mb-3">
                        <label>Plan Name</label>
                        <input type="text" class="form-control" name="name" required placeholder="Enter Plan Name">
                    </div>
                    <div class="mb-3">
                        <label>No Of Days</label>
                        <input type="number" class="form-control" name="days" required placeholder="Enter Day">
                    </div>
                    <!-- Amounts side by side -->
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label>Level 1 (in %)</label>
                            <input type="number"   name="level_1" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 2 (in %)</label>
                            <input type="number"   name="level_2" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 3 (in %)</label>
                            <input type="number"   name="level_3" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 4 (in %)</label>
                            <input type="number"   name="level_4" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 5 (in %)</label>
                            <input type="number"   name="level_5" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 6 (in %)</label>
                            <input type="number"   name="level_6" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 7 (in %)</label>
                            <input type="number"   name="level_7" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 8 (in %)</label>
                            <input type="number"   name="level_8" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 9 (in %)</label>
                            <input type="number"   name="level_9" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 10 (in %)</label>
                            <input type="number"   name="level_10" required class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Level 11 To 25 (in %)</label>
                            <input type="number"   name="level_11" required class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save Data</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    var tabledata = $('#Datatable').DataTable({
        processing: true,
        serverSide: true,
        "order": [[1, "asc"]],
        ajax: '<?php echo e(asset("packages/plandata")); ?>',
        columns: [
            {data: 'code', name: 'code'},
            {data: 'name', name: 'name'},
            {data: 'days', name: 'days'},
            {data: 'level_1', name: 'level_1'},
            {data: 'level_2', name: 'level_2'},
            {data: 'level_3', name: 'level_3'},
            {data: 'level_4', name: 'level_4'},
            {data: 'level_5', name: 'level_5'},
            {data: 'level_6', name: 'level_6'},
            {data: 'level_7', name: 'level_7'},
            {data: 'level_8', name: 'level_8'},
            {data: 'level_9', name: 'level_9'},
            {data: 'level_10', name: 'level_10'},
            {data: 'level_11', name: 'level_11'},
            {data: 'action', name: 'action', orderable: false, searchable: false, width: '100px'}
        ]
    });

    $(document).on('click', '#openaddmodel', function () {
        $('#openaddmodelModal').modal('show');
    });
    $(document).on('click', '.delete_btn', function () {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#17a2b8',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo e(URL::asset('packages/deleteplan')); ?>",
                    data: {delete_row: 'delete_row', 'row_id': $(this).attr('id')},
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': '<?= csrf_token() ?>'
                    },
                    success: function (data)
                    {
                        tabledata.draw();
                    },
                    cache: false,
                });
            }
        });
    });

    $(document).on('click', '.update_btn', function () {
        $.ajax({
            url: "<?php echo e(URL::asset('packages/editplandata')); ?>",
            data: {edit_data: 'edit_data', 'row_id': $(this).attr('id')},
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': '<?= csrf_token() ?>'
            },
            success: function (data)
            {
                $(document).find("input[name='update_id']").val(data.row.id);
                $(document).find("input[name='code']").val(data.row.code);
                $(document).find("input[name='name']").val(data.row.name);
                $(document).find("input[name='days']").val(data.row.days);
                $(document).find("input[name='level_1']").val(data.row.level_1);
                $(document).find("input[name='level_2']").val(data.row.level_2);
                $(document).find("input[name='level_3']").val(data.row.level_3);
                $(document).find("input[name='level_4']").val(data.row.level_4);
                $(document).find("input[name='level_5']").val(data.row.level_5);
                $(document).find("input[name='level_6']").val(data.row.level_6);
                $(document).find("input[name='level_7']").val(data.row.level_7);
                $(document).find("input[name='level_8']").val(data.row.level_8);
                $(document).find("input[name='level_9']").val(data.row.level_9);
                $(document).find("input[name='level_10']").val(data.row.level_10);
                $('#openaddmodelModal').modal('show');
            },
            cache: false,
        });
    });

    $(function () {
        $('#quickForm').validate({
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/packages_plan.blade.php ENDPATH**/ ?>