<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>MalaysianTrade | Login / Register</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
        <style>
            body {
                background: radial-gradient(circle at 20% 20%, #141414 0%, #0a0a0a 100%);
                font-family: 'Poppins', sans-serif;
                color: #fff;
            }

            .auth-container {
                max-width: 420px;
                margin: 5vh auto;
                background: rgba(20, 20, 20, 0.9);
                border: 1px solid rgba(255, 255, 255, 0.08);
                border-radius: 16px;
                box-shadow: 0 0 30px rgba(255, 0, 0, 0.15);
                color:#fff;
                padding: 25px 20px;
                backdrop-filter: blur(8px);
            }

            .auth-logo {
                display: block;
                max-width: 180px;
                margin: 0 auto 25px auto;
            }

            .nav-tabs {
                border-bottom: 1px solid #2b2f38;
            }

            .nav-tabs .nav-link {
                color: #bbb;
            }

            .nav-tabs .nav-link.active {
                color: #000;
                background-color: #fff;
                border-color: transparent transparent #fcd535;
                border-bottom: 2px solid #fca311;
            }

            label {
                color: #ccc;
                font-size: 14px;
            }
            .form-control {
                background: rgba(255, 255, 255, 0.08);
                border: 1px solid rgba(255, 255, 255, 0.15);
                color: #fff;
                border-radius: 8px;
            }
            .form-control::placeholder {
                color: #aaa;
            }
            .form-control:focus {
                border-color: #e63946;
                box-shadow: 0 0 0 0.2rem rgba(230, 57, 70, 0.25);
                background: rgba(255, 255, 255, 0.12);
                color:#fff;
            }
            .dropdown-toggle{
                background: rgba(255, 255, 255, 0.08);
                color: #fff;
            }
            .bs-searchbox .form-control{
                color:#000 !important;
                border-color: #000;
                box-shadow: 0 0 0 0.2rem rgba(255, 255, 255, 0.08);
            }
            /* Main action buttons */
            .btn-yellow {
                background: linear-gradient(90deg, #e63946 0%, #fca311 100%);
                color: #fff;
                border: none;
                border-radius: 8px;
                font-weight: 600;
                padding: 12px;
                transition: all 0.3s ease;
            }
            .btn-yellow:hover {
                box-shadow: 0 5px 20px rgba(252, 163, 17, 0.4);
                transform: translateY(-2px);
            }

            /* Divider text */
            .divider {
                text-align: center;
                margin: 20px 0;
                color: #888;
                font-size: 14px;
            }

            .social-btn {
                background-color: transparent;
                border: 1px solid #2b2f38;
                color: #fff;
                width: 100%;
            }

            .social-btn:hover {
                background: rgba(255,255,255,0.12);
                transform: translateY(-1px);
            }

            .social-btn img {
                margin-right: 8px;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="auth-container">
                <img src="<?php echo e(asset('images/logo.png')); ?>" alt="MalaysianTrade Logo" class="auth-logo img-fluid">

                <ul class="nav nav-tabs justify-content-center mb-4" id="authTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="login-tab" data-bs-toggle="tab" data-bs-target="#login" type="button" role="tab">Login</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="register-tab" data-bs-toggle="tab" data-bs-target="#register" type="button" role="tab">Register</button>
                    </li>
                </ul>
                <div class="tab-content" id="authTabsContent">

                    <!-- Login Tab -->
                    <div class="tab-pane fade show active" id="login" role="tabpanel">
                        <?php if(\Session::get('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            <?php echo e(\Session::get('success')); ?>

                        </div>
                        <?php endif; ?>
                        <?php if(\Session::get('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-exclamation-triangle"></i> Error!</h5>
                            <?php echo e(\Session::get('error')); ?>

                        </div>
                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('login')); ?>" class="user" id="loginform">
                            <?php echo e(csrf_field()); ?>

                            <input type="text" style="display:none">
                            <input type="password" style="display:none">
                            <div class="mb-3">
                                <label>User ID</label>
                                <input  type="text" placeholder="Enter UserID" class="form-control form-control-user <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="username" value="<?php echo e(old('username')); ?>" required  autofocus>
                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <input id="password" class="block mt-1 w-full password form-control form-control-user <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="password" placeholder="Password" name="password" required />
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <button type="submit" class="btn btn-yellow w-100">Log In</button>
                        </form>
                        <br>
                        <button class="btn social-btn mb-2">
                            <a class="btn btn-link" href="<?php echo e(route('password.request')); ?>" style="color:#fff;margin:auto;">
                                <?php echo e(__('Forgot Your Password?')); ?>

                            </a>
                        </button>
                        <div class="divider">or</div>
 
                       <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/color/20/google-logo.png"/> Continue with Google
                        </button>
                        <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/ios-filled/20/mac-os.png"/> Continue with Apple
                        </button>
                        <button class="btn social-btn">
                            <img src="https://img.icons8.com/ios-filled/20/telegram-app.png"/> Continue with Telegram
                        </button>
                    </div>

                    <!-- Register Tab -->
                    <div class="tab-pane fade" id="register" role="tabpanel">
                        <form method="POST" action="<?php echo e(route('register')); ?>" class="user" id="registerform">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label>Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Enter your full name" required>
                            </div>

                            <div class="mb-3">
                                <label>Mobile Number</label>
                                <div class="input-group">
                                    <select class="form-select" name="country_code" style="max-width: 100px;">
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($coun->phonecode); ?>" <?= $coun->name == 'India' ? 'selected' : '' ?>>+<?php echo e($coun->phonecode); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <input type="text" name="mobile" class="form-control" placeholder="Enter phone number" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label>PAN Card</label>
                                <input type="text" name="pan_no" class="form-control" placeholder="ABC123FG">
                            </div>
                            <div class="mb-3">
                                <label>Email ID</label>
                                <input type="email" name="email" class="form-control" placeholder="email@example.com">
                            </div>

                            <div class="mb-3">
                                <label>Country</label>
                                <select class="selectpicker" id="change_country" data-width="100%" data-live-search="true" name="country" required>
                                    <option value="">SelectOne</option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($coun->name); ?>"><?php echo e($coun->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label>State</label>
                                <select class="selectpicker" id="change_state" data-width="100%" data-live-search="true" name="state" required>
                                    <option value="">SelectOne</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label>Referred By</label>
                                <?php if(request('sponser')): ?>
                                <input id="sponsor_change" class="form-control form-control-user" type="text" value="<?php echo e(request('sponser')); ?>" readonly placeholder="Sponser ID" name="sponser" required />
                                <input class="form-control form-control-user" type="hidden" value="<?php echo e(request('position')); ?>"  placeholder="Referral" name="position" required />
                                <?php else: ?>
                                <input id="sponsor_change" class="form-control form-control-user" type="text" value="<?php echo e(request('reffer')); ?>"  placeholder="Referral" name="sponser" required />
                                <?php endif; ?>
                                <div id="sponsor_response"></div>
                            </div>

                            <h5>Bank Details</h5>
                            <div class="mb-3">
                                <label>Account Number</label>
                                <input type="text" class="form-control" name="account_number" placeholder="Account Number">
                            </div>
                            <div class="mb-3">
                                <label>Bank Name</label>
                                <select class="selectpicker" data-width="100%" data-live-search="true" name="bank_name">
                                    <option value="">SelectOne</option>
                                    <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($bank->name); ?>" ><?php echo e($bank->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label>Branch Name</label>
                                <input type="txt" class="form-control" placeholder="Branch" name="branch_name"/>
                            </div>
                            <div class="mb-3">
                                <label>IFSC Code</label>
                                <input type="txt" class="form-control" placeholder="IFSC Code"  name="ifsc_code"/>
                            </div>
                            <button type="submit" class="btn btn-yellow w-100">Register</button>
                        </form>

                        <div class="divider">or</div>

                        <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/color/20/google-logo.png"/> Continue with Google
                        </button>
                        <button class="btn social-btn mb-2">
                            <img src="https://img.icons8.com/ios-filled/20/mac-os.png"/> Continue with Apple
                        </button>
                        <button class="btn social-btn">
                            <img src="https://img.icons8.com/ios-filled/20/telegram-app.png"/> Continue with Telegram
                        </button>
                    </div>

                </div>
            </div>
        </div>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
        <!-- Core plugin JavaScript-->
        <script src="<?php echo e(asset('plugins/jquery-easing/jquery.easing.min.js')); ?>"></script>
        <!-- Custom scripts for all pages-->
        <script src="<?php echo e(asset('js/sb-admin-2.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/jquery.validate.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/additional-methods.min.js')); ?>"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
        <script>
$(document).ready(function () {
    $('.selectpicker').selectpicker();
    $(document).on('change', '#change_country', function () {
        var countryID = $(this).val();
        if (countryID) {
            $.ajax({
                url: "<?php echo e(asset('getstates')); ?>",
                type: "POST",
                data: {
                    country_id: countryID,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function (data) {
                    $('#change_state').empty().append('<option value="">Select One</option>');
                    $.each(data, function (key, value) {
                        $('#change_state').append('<option value="' + value.state + '">' + value.state + '</option>');
                    });
                    $('#change_state').selectpicker('refresh');
                }
            });
        } else {
            $('#change_state').empty().append('<option value="">Select One</option>').selectpicker('refresh');
        }
    });
    $(document).on('blur', '#sponsor_change', function () {
        if ($(this).val() != '')
        {
            var sponsor = $("#sponsor_change").val().trim();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                url: "<?php echo e(asset('frontdata/fetchsponsor')); ?>",
                method: "POST",
                data: {sponsor: sponsor, _token: _token},
                success: function (response)
                {
                    if (response) {
                        $("#sponsor_response").html(response);
                    } else {
                        $("#sponsor_response").html('Invalid Sponsor ID');
                    }
                }
            })
        }
    });
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $(function () {
        $('#registerform').validate({
            rules: {
                username: {
                    required: true,
                    alphanumeric: true
                },
                mobile: {
                    minlength: 10,
                    maxlength: 10

                },
                password: {
                    minlength: 6
                },
                password_confirm: {
                    minlength: 6,
                    equalTo: "#samepassword"
                }
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                error.insertAfter(element);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


});
        </script>
    </body>
</html>
<?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/auth/login.blade.php ENDPATH**/ ?>