
<?php $__env->startSection('css'); ?>
<style>
    .tab-content {
        border: 1px solid #ddd;
        border-width: 0 1px 1px;
        padding: 20px;
        background: #fff;
    }
    .top {
    margin-bottom: 10px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Payout Report</h1>
</div>
<div class="row">
    <div class="col-md-12">
        <form class="form-inline">
            <div class="form-group">
                <label>Form Date </label>
                <input type="date" name="form_date" value="<?php echo e(request('form_date')); ?>" class="form-control" />
                <label>To Date </label>
                <input type="date" name="till_date" value="<?php echo e(request('till_date')); ?>" class="form-control"/>
            </div>
            <button type="submit" class="btn btn-success">Find</button>
        </form>
    </div>
</div>
<br>
<br>
<div class="row">
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="Datatable" class="table table-bordered table-striped">
                                <thead>
                                    <tr class="seprator">
                                        <th>Member ID</th>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Bank Account No</th>
                                        <th>Bank Name</th>
                                        <th>Branch</th>
                                        <th>IFSC Code</th>
                                        <th>Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($row->username); ?></td>
                                        <td><?php echo e($row->name); ?></td>
                                        <td><?php echo e($row->mobile); ?></td>
                                        <?php
                                        $bank = \App\BankAccount::where('user_id', $row->id)->first();
                                        ?>
                                        <?php if($bank): ?>
                                        <td><?php echo e($bank->number); ?></td>
                                        <td><?php echo e($bank->bank_name); ?></td>
                                        <td><?php echo e($bank->branch_name); ?></td>
                                        <td><?php echo e($bank->ifsc_code); ?></td>
                                        <?php else: ?>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <?php endif; ?>
                                        <td>
                                            <?php echo e(App\WalletRequest::amountFormat(\App\Wallet::getWalletblanceDate($row->id,request('form_date'),request('till_date')))); ?>

                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script>
$('#Datatable').DataTable({
    dom: '<"top d-flex justify-content-between align-items-center"Bfl>rtip',
    buttons: [
        {
            extend: 'excelHtml5',
            text: 'Excel',
            title: 'Payout Report'
        }
    ],
    lengthMenu: [
        [10, 25, 50, 100, -1],
        [10, 25, 50, 100, "All"]
    ]
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/admin/payout_report.blade.php ENDPATH**/ ?>