<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>MalaysianTrade | Login / Register</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
        <style>
            body {
                background: radial-gradient(circle at 20% 20%, #141414 0%, #0a0a0a 100%);
                font-family: 'Poppins', sans-serif;
                color: #fff;
            }

            .auth-container {
                max-width: 420px;
                margin: 5vh auto;
                background: rgba(20, 20, 20, 0.9);
                border: 1px solid rgba(255, 255, 255, 0.08);
                border-radius: 16px;
                box-shadow: 0 0 30px rgba(255, 0, 0, 0.15);
                color:#fff;
                padding: 25px 20px;
                backdrop-filter: blur(8px);
            }

            .auth-logo {
                display: block;
                max-width: 180px;
                margin: 0 auto 25px auto;
            }

            .nav-tabs {
                border-bottom: 1px solid #2b2f38;
            }

            .nav-tabs .nav-link {
                color: #bbb;
            }

            .nav-tabs .nav-link.active {
                color: #000;
                background-color: #fff;
                border-color: transparent transparent #fcd535;
                border-bottom: 2px solid #fca311;
            }

            label {
                color: #ccc;
                font-size: 14px;
            }
            .form-control {
                background: rgba(255, 255, 255, 0.08);
                border: 1px solid rgba(255, 255, 255, 0.15);
                color: #fff;
                border-radius: 8px;
            }
            .form-control::placeholder {
                color: #aaa;
            }
            .form-control:focus {
                border-color: #e63946;
                box-shadow: 0 0 0 0.2rem rgba(230, 57, 70, 0.25);
                background: rgba(255, 255, 255, 0.12);
                color:#fff;
            }
            .dropdown-toggle{
                background: rgba(255, 255, 255, 0.08);
                color: #fff;
            }
            .bs-searchbox .form-control{
                color:#000 !important;
                border-color: #000;
                box-shadow: 0 0 0 0.2rem rgba(255, 255, 255, 0.08);
            }
            /* Main action buttons */
            .btn-yellow {
                background: linear-gradient(90deg, #e63946 0%, #fca311 100%);
                color: #fff;
                border: none;
                border-radius: 8px;
                font-weight: 600;
                padding: 12px;
                transition: all 0.3s ease;
            }
            .btn-yellow:hover {
                box-shadow: 0 5px 20px rgba(252, 163, 17, 0.4);
                transform: translateY(-2px);
            }

            /* Divider text */
            .divider {
                text-align: center;
                margin: 20px 0;
                color: #888;
                font-size: 14px;
            }

            .social-btn {
                background-color: transparent;
                border: 1px solid #2b2f38;
                color: #fff;
                width: 100%;
            }

            .social-btn:hover {
                background: rgba(255,255,255,0.12);
                transform: translateY(-1px);
            }

            .social-btn img {
                margin-right: 8px;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="auth-container">
                <img src="<?php echo e(asset('images/logo.png')); ?>" alt="MalaysianTrade Logo" class="auth-logo img-fluid">
                <div class="">
                    <h3><?php echo e(__('Reset Password')); ?></h3>
                    <div class="">
                        <?php if(session('status')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session('status')); ?>

                        </div>
                        <?php endif; ?>
                        <?php if(\Session::get('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-check"></i> Success!</h5>
                            <?php echo e(\Session::get('success')); ?>

                        </div>
                        <?php endif; ?>
                        <?php if(\Session::get('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-exclamation-triangle"></i> Error!</h5>
                            <?php echo e(\Session::get('error')); ?>

                        </div>
                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('password.email')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group row">
                                <label for="email" class="col-form-label text-md-right"><?php echo e(__('E-Mail Address')); ?></label>
                                <div class="col-md-12">
                                    <input id="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <br>
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Send Password Reset Link')); ?>

                                    </button>
                                </div>
                            </div>
                            <br>
                            <br>
                            <br>
                            <button class="btn social-btn mb-2">
                                <a href="<?php echo e(asset('/')); ?>"> Back To Login</a>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
        <!-- Core plugin JavaScript-->
        <script src="<?php echo e(asset('plugins/jquery-easing/jquery.easing.min.js')); ?>"></script>
        <!-- Custom scripts for all pages-->
        <script src="<?php echo e(asset('js/sb-admin-2.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/jquery.validate.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/jquery-validation/additional-methods.min.js')); ?>"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
        <script>

        </script>
    </body>
</html>
<?php /**PATH /home/malaysiantrade/public_html/trade/resources/views/auth/passwords/email.blade.php ENDPATH**/ ?>